/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.common.utils;

import java.lang.reflect.InvocationTargetException;
import java.util.LinkedList;
import java.util.List;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import org.apache.seatunnel.engine.common.exception.SeaTunnelEngineException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FactoryUtil<T> {
    private static final Logger log = LoggerFactory.getLogger(FactoryUtil.class);

    public static <T> T discoverFactory(ClassLoader classLoader, Class<T> factoryClass, String factoryIdentifier) {
        try {
            LinkedList result = new LinkedList();
            ServiceLoader.load(factoryClass, classLoader).iterator().forEachRemaining(result::add);
            List foundFactories = result.stream().filter(f -> factoryClass.isAssignableFrom(f.getClass())).filter(t -> {
                try {
                    return t.getClass().getMethod("factoryIdentifier", new Class[0]).invoke(t, new Object[0]).equals(factoryIdentifier);
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    throw new SeaTunnelEngineException("Failed to call factoryIdentifier method.");
                }
            }).collect(Collectors.toList());
            if (foundFactories.isEmpty()) {
                throw new SeaTunnelEngineException(String.format("Could not find any factories that implement '%s' in the classpath.", factoryClass.getName()));
            }
            if (foundFactories.size() > 1) {
                throw new SeaTunnelEngineException(String.format("Multiple factories for identifier '%s' that implement '%s' found in the classpath.\n\nAmbiguous factory classes are:\n\n%s", factoryIdentifier, factoryClass.getName(), foundFactories.stream().map(f -> f.getClass().getName()).sorted().collect(Collectors.joining("\n"))));
            }
            return foundFactories.get(0);
        }
        catch (ServiceConfigurationError e) {
            log.error("Could not load service provider for factories.", e);
            throw new SeaTunnelEngineException("Could not load service provider for factories.", e);
        }
    }
}

