/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.core.job;

import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import org.apache.seatunnel.engine.core.job.CommonPluginJar;
import org.apache.seatunnel.engine.core.job.ConnectorJarType;
import org.apache.seatunnel.engine.core.job.ConnectorPluginJar;
import org.apache.seatunnel.shade.com.google.common.base.Preconditions;

public abstract class ConnectorJar
implements IdentifiedDataSerializable {
    protected byte[] connectorJarID;
    protected ConnectorJarType type;
    protected byte[] data;
    protected String fileName;

    public ConnectorJar() {
    }

    protected ConnectorJar(ConnectorJarType type, byte[] data, String fileName) {
        Preconditions.checkNotNull(data);
        if (data.length == 0) {
            throw new IllegalArgumentException("The Jar package file for the connector is empty!");
        }
        Preconditions.checkNotNull(type);
        Preconditions.checkNotNull(fileName);
        this.type = type;
        this.data = data;
        this.fileName = fileName;
    }

    protected ConnectorJar(byte[] connectorJarID, ConnectorJarType type, byte[] data, String fileName) {
        Preconditions.checkNotNull(data);
        if (data.length == 0) {
            throw new IllegalArgumentException("The Jar package file for the connector is empty!");
        }
        Preconditions.checkNotNull(connectorJarID);
        Preconditions.checkNotNull(type);
        Preconditions.checkNotNull(fileName);
        this.connectorJarID = connectorJarID;
        this.type = type;
        this.data = data;
        this.fileName = fileName;
    }

    public static ConnectorJar createConnectorJar(ConnectorJarType type, byte[] data, String fileName) {
        if (type == ConnectorJarType.COMMON_PLUGIN_JAR) {
            return new CommonPluginJar(data, fileName);
        }
        return new ConnectorPluginJar(data, fileName);
    }

    public static ConnectorJar createConnectorJar(byte[] connectorJarID, ConnectorJarType type, byte[] data, String fileName) {
        if (type == ConnectorJarType.COMMON_PLUGIN_JAR) {
            return new CommonPluginJar(connectorJarID, data, fileName);
        }
        return new ConnectorPluginJar(connectorJarID, data, fileName);
    }

    public byte[] getConnectorJarID() {
        return this.connectorJarID;
    }

    public ConnectorJarType getType() {
        return this.type;
    }

    public byte[] getData() {
        return this.data;
    }

    public String getFileName() {
        return this.fileName;
    }
}

