/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.format.json.canal;

import java.io.IOException;
import java.util.regex.Pattern;
import org.apache.seatunnel.api.serialization.DeserializationSchema;
import org.apache.seatunnel.api.source.Collector;
import org.apache.seatunnel.api.table.type.RowKind;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.common.exception.CommonError;
import org.apache.seatunnel.common.exception.SeaTunnelRuntimeException;
import org.apache.seatunnel.format.json.JsonDeserializationSchema;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.JsonNode;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.node.ArrayNode;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.node.ObjectNode;

public class CanalJsonDeserializationSchema
implements DeserializationSchema<SeaTunnelRow> {
    private static final long serialVersionUID = 1L;
    private static final String FORMAT = "Canal";
    private static final String FIELD_OLD = "old";
    private static final String FIELD_DATA = "data";
    private static final String FIELD_TYPE = "type";
    private static final String FIELD_DATABASE = "database";
    private static final String FIELD_TABLE = "table";
    private static final String OP_INSERT = "INSERT";
    private static final String OP_UPDATE = "UPDATE";
    private static final String OP_DELETE = "DELETE";
    private static final String OP_CREATE = "CREATE";
    private static final String OP_QUERY = "QUERY";
    private static final String OP_ALTER = "ALTER";
    private String database;
    private String table;
    private final String[] fieldNames;
    private final int fieldCount;
    private boolean ignoreParseErrors;
    private final Pattern databasePattern;
    private final Pattern tablePattern;
    private final JsonDeserializationSchema jsonDeserializer;
    private final SeaTunnelRowType physicalRowType;

    public CanalJsonDeserializationSchema(SeaTunnelRowType physicalRowType, String database, String table, boolean ignoreParseErrors) {
        this.physicalRowType = physicalRowType;
        SeaTunnelRowType jsonRowType = CanalJsonDeserializationSchema.createJsonRowType(physicalRowType);
        this.jsonDeserializer = new JsonDeserializationSchema(false, ignoreParseErrors, jsonRowType);
        this.database = database;
        this.table = table;
        this.fieldNames = physicalRowType.getFieldNames();
        this.fieldCount = physicalRowType.getTotalFields();
        this.ignoreParseErrors = ignoreParseErrors;
        this.databasePattern = database == null ? null : Pattern.compile(database);
        this.tablePattern = table == null ? null : Pattern.compile(table);
    }

    public SeaTunnelRow deserialize(byte[] message) throws IOException {
        throw new UnsupportedOperationException("Please invoke DeserializationSchema#deserialize(byte[], Collector<SeaTunnelRow>) instead.");
    }

    public SeaTunnelDataType<SeaTunnelRow> getProducedType() {
        return this.physicalRowType;
    }

    public void deserialize(ObjectNode jsonNode, Collector<SeaTunnelRow> out) throws IOException {
        block13: {
            try {
                if (this.database != null && !this.databasePattern.matcher(jsonNode.get(FIELD_DATABASE).asText()).matches()) {
                    return;
                }
                if (this.table != null && !this.tablePattern.matcher(jsonNode.get(FIELD_TABLE).asText()).matches()) {
                    return;
                }
                JsonNode dataNode = jsonNode.get(FIELD_DATA);
                String type = jsonNode.get(FIELD_TYPE).asText();
                if (dataNode == null || dataNode.isNull()) {
                    if (OP_QUERY.equals(type) || OP_CREATE.equals(type) || OP_ALTER.equals(type)) {
                        return;
                    }
                    throw new IllegalStateException(String.format("Null data value '%s' Cannot send downstream", jsonNode));
                }
                if (OP_INSERT.equals(type)) {
                    for (int i = 0; i < dataNode.size(); ++i) {
                        SeaTunnelRow row = this.convertJsonNode(dataNode.get(i));
                        out.collect((Object)row);
                    }
                    break block13;
                }
                if (OP_UPDATE.equals(type)) {
                    ArrayNode oldNode = (ArrayNode)jsonNode.get(FIELD_OLD);
                    for (int i = 0; i < dataNode.size(); ++i) {
                        SeaTunnelRow after = this.convertJsonNode(dataNode.get(i));
                        SeaTunnelRow before = this.convertJsonNode(oldNode.get(i));
                        for (int f = 0; f < this.fieldCount; ++f) {
                            if (!before.isNullAt(f) || oldNode.findValue(this.fieldNames[f]) != null) continue;
                            before.setField(f, after.getField(f));
                        }
                        before.setRowKind(RowKind.UPDATE_BEFORE);
                        after.setRowKind(RowKind.UPDATE_AFTER);
                        out.collect((Object)before);
                        out.collect((Object)after);
                    }
                    break block13;
                }
                if (OP_DELETE.equals(type)) {
                    for (int i = 0; i < dataNode.size(); ++i) {
                        SeaTunnelRow row = this.convertJsonNode(dataNode.get(i));
                        row.setRowKind(RowKind.DELETE);
                        out.collect((Object)row);
                    }
                    break block13;
                }
                throw new IllegalStateException(String.format("Unknown operation type '%s'.", type));
            }
            catch (RuntimeException e) {
                if (this.ignoreParseErrors) break block13;
                throw CommonError.jsonOperationError((String)FORMAT, (String)jsonNode.toString(), (Throwable)e);
            }
        }
    }

    private ObjectNode convertBytes(byte[] message) throws SeaTunnelRuntimeException {
        try {
            return (ObjectNode)this.jsonDeserializer.deserializeToJsonNode(message);
        }
        catch (Throwable t) {
            throw CommonError.jsonOperationError((String)FORMAT, (String)new String(message), (Throwable)t);
        }
    }

    public void deserialize(byte[] message, Collector<SeaTunnelRow> out) throws IOException {
        ObjectNode jsonNode;
        if (message == null) {
            return;
        }
        try {
            jsonNode = this.convertBytes(message);
        }
        catch (SeaTunnelRuntimeException cause) {
            if (!this.ignoreParseErrors) {
                throw cause;
            }
            return;
        }
        this.deserialize(jsonNode, out);
    }

    private SeaTunnelRow convertJsonNode(JsonNode root) {
        return this.jsonDeserializer.convertToRowData(root);
    }

    private static SeaTunnelRowType createJsonRowType(SeaTunnelRowType physicalDataType) {
        return physicalDataType;
    }

    public static Builder builder(SeaTunnelRowType physicalDataType) {
        return new Builder(physicalDataType);
    }

    public static class Builder {
        private boolean ignoreParseErrors = false;
        private String database = null;
        private String table = null;
        private final SeaTunnelRowType physicalDataType;

        public Builder(SeaTunnelRowType physicalDataType) {
            this.physicalDataType = physicalDataType;
        }

        public Builder setDatabase(String database) {
            this.database = database;
            return this;
        }

        public Builder setTable(String table) {
            this.table = table;
            return this;
        }

        public Builder setIgnoreParseErrors(boolean ignoreParseErrors) {
            this.ignoreParseErrors = ignoreParseErrors;
            return this;
        }

        public CanalJsonDeserializationSchema build() {
            return new CanalJsonDeserializationSchema(this.physicalDataType, this.database, this.table, this.ignoreParseErrors);
        }
    }
}

