/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.transform.jsonpath;

import com.google.auto.service.AutoService;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.configuration.util.OptionRule;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.connector.TableTransform;
import org.apache.seatunnel.api.table.factory.Factory;
import org.apache.seatunnel.api.table.factory.TableTransformFactory;
import org.apache.seatunnel.api.table.factory.TableTransformFactoryContext;
import org.apache.seatunnel.transform.jsonpath.JsonPathTransform;
import org.apache.seatunnel.transform.jsonpath.JsonPathTransformConfig;

@AutoService(value={Factory.class})
public class JsonPathTransformFactory
implements TableTransformFactory {
    public String factoryIdentifier() {
        return "JsonPath";
    }

    public OptionRule optionRule() {
        return OptionRule.builder().required(new Option[]{JsonPathTransformConfig.COLUMNS}).build();
    }

    public TableTransform createTransform(TableTransformFactoryContext context) {
        CatalogTable catalogTable = (CatalogTable)context.getCatalogTables().get(0);
        ReadonlyConfig options = context.getOptions();
        JsonPathTransformConfig jsonPathTransformConfig = JsonPathTransformConfig.of(options);
        return () -> new JsonPathTransform(jsonPathTransformConfig, catalogTable);
    }
}

