/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.net;

import java.io.FilterInputStream;
import java.io.InputStream;
import java.net.Socket;
import java.net.SocketException;
import java.nio.channels.ReadableByteChannel;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.net.SocketInputStream;
import org.apache.seatunnel.shade.hadoop.com.google.common.base.Preconditions;

@InterfaceAudience.LimitedPrivate(value={"HDFS"})
@InterfaceStability.Unstable
public class SocketInputWrapper
extends FilterInputStream {
    private final Socket socket;
    private final boolean hasChannel;

    SocketInputWrapper(Socket s2, InputStream is) {
        super(is);
        this.socket = s2;
        boolean bl = this.hasChannel = s2.getChannel() != null;
        if (this.hasChannel) {
            Preconditions.checkArgument(is instanceof SocketInputStream, "Expected a SocketInputStream when there is a channel. Got: %s", (Object)is);
        }
    }

    public void setTimeout(long timeoutMs) throws SocketException {
        if (this.hasChannel) {
            ((SocketInputStream)this.in).setTimeout(timeoutMs);
        } else {
            this.socket.setSoTimeout((int)timeoutMs);
        }
    }

    public ReadableByteChannel getReadableByteChannel() {
        Preconditions.checkState(this.hasChannel, "Socket %s does not have a channel", (Object)this.socket);
        return (SocketInputStream)this.in;
    }
}

