/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.transform.sql.zeta.functions.udf;

import java.security.Key;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.IvParameterSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DESUtil {
    private static final Logger log = LoggerFactory.getLogger(DESUtil.class);
    private static final String IV_PARAMETER = "12345678";
    private static final String ALGORITHM = "DES";
    private static final String CIPHER_ALGORITHM = "DES/CBC/PKCS5Padding";
    private static final String CHARSET = "utf-8";

    private static Key generateKey(String password) throws Exception {
        DESKeySpec dks = new DESKeySpec(password.getBytes(CHARSET));
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(ALGORITHM);
        return keyFactory.generateSecret(dks);
    }

    public static String encrypt(String password, String data) {
        if (password == null || password.length() < 8) {
            throw new RuntimeException("Encrypt failed, password length must greater than 8");
        }
        if (data == null) {
            return null;
        }
        try {
            Key secretKey = DESUtil.generateKey(password);
            Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
            IvParameterSpec iv = new IvParameterSpec(IV_PARAMETER.getBytes(CHARSET));
            cipher.init(1, secretKey, iv);
            byte[] bytes = cipher.doFinal(data.getBytes(CHARSET));
            return new String(Base64.getEncoder().encode(bytes));
        }
        catch (Exception e) {
            log.error("Encrypt failed", (Throwable)e);
            return data;
        }
    }

    public static String decrypt(String password, String data) {
        if (password == null || password.length() < 8) {
            throw new RuntimeException("Encrypt failed, password length must greater than 8");
        }
        if (data == null) {
            return null;
        }
        try {
            Key secretKey = DESUtil.generateKey(password);
            Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
            IvParameterSpec iv = new IvParameterSpec(IV_PARAMETER.getBytes(CHARSET));
            cipher.init(2, secretKey, iv);
            return new String(cipher.doFinal(Base64.getDecoder().decode(data.getBytes(CHARSET))), CHARSET);
        }
        catch (Exception e) {
            log.error("Decrypt failed", (Throwable)e);
            return data;
        }
    }
}

