/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.metrics.managementcenter;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;

public class ConcurrentArrayRingbuffer<E> {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private final E[] ringItems;
    private long head;
    private long tail;
    private final int capacity;

    public ConcurrentArrayRingbuffer(int capacity) {
        this.capacity = capacity;
        this.ringItems = new Object[capacity];
    }

    public synchronized void add(E item) {
        if (this.tail - (long)this.capacity == this.head) {
            ++this.head;
        }
        this.ringItems[this.toIndex((long)this.tail++)] = item;
    }

    public synchronized void clear() {
        Arrays.fill(this.ringItems, null);
        this.head = this.tail;
    }

    public synchronized E get(long sequence) {
        this.checkSequence(sequence);
        return this.ringItems[this.toIndex(sequence)];
    }

    public synchronized RingbufferSlice<E> copyFrom(long sequence) {
        if ((sequence = Math.max(sequence, this.head)) == this.tail) {
            return new RingbufferSlice(EMPTY_ARRAY, this.tail);
        }
        this.checkSequence(sequence);
        Object[] result = new Object[(int)(this.tail - sequence)];
        int startPoint = this.toIndex(sequence);
        int endPoint = this.toIndex(this.tail);
        if (startPoint >= endPoint) {
            System.arraycopy(this.ringItems, startPoint, result, 0, this.capacity - startPoint);
            System.arraycopy(this.ringItems, 0, result, this.capacity - startPoint, endPoint);
        } else {
            System.arraycopy(this.ringItems, startPoint, result, 0, endPoint - startPoint);
        }
        return new RingbufferSlice(result, this.tail);
    }

    public int getCapacity() {
        return this.capacity;
    }

    public synchronized long size() {
        return this.tail - this.head;
    }

    public synchronized boolean isEmpty() {
        return this.tail == this.head;
    }

    private void checkSequence(long sequence) {
        if (sequence >= this.tail) {
            throw new IllegalArgumentException("sequence:" + sequence + " is too large. The current tail is:" + this.tail);
        }
        if (sequence < this.head) {
            throw new IllegalArgumentException("sequence:" + sequence + " is too small. The current headSequence is:" + this.head + " tailSequence is:" + this.tail);
        }
    }

    private int toIndex(long sequence) {
        return (int)(sequence % (long)this.ringItems.length);
    }

    public static final class RingbufferSlice<E> {
        private Object[] elements;
        private long nextSequence;

        private RingbufferSlice(E[] elements, long nextSequence) {
            this.elements = elements;
            this.nextSequence = nextSequence;
        }

        public List<E> elements() {
            return Arrays.asList(this.elements);
        }

        public Stream<E> stream() {
            return Arrays.stream(this.elements);
        }

        public boolean isEmpty() {
            return this.elements.length == 0;
        }

        public long nextSequence() {
            return this.nextSequence;
        }
    }
}

