/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.api.table.type;

public enum RowKind {
    INSERT("+I", 0),
    UPDATE_BEFORE("-U", 1),
    UPDATE_AFTER("+U", 2),
    DELETE("-D", 3);

    private final String shortString;
    private final byte value;

    private RowKind(String shortString, byte value) {
        this.shortString = shortString;
        this.value = value;
    }

    public String shortString() {
        return this.shortString;
    }

    public byte toByteValue() {
        return this.value;
    }

    public static RowKind fromByteValue(byte value) {
        switch (value) {
            case 0: {
                return INSERT;
            }
            case 1: {
                return UPDATE_BEFORE;
            }
            case 2: {
                return UPDATE_AFTER;
            }
            case 3: {
                return DELETE;
            }
        }
        throw new UnsupportedOperationException("Unsupported byte value '" + value + "' for row kind.");
    }
}

