/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.resourcemanager.opeartion;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.impl.operationservice.Operation;
import java.io.IOException;
import org.apache.seatunnel.engine.server.SeaTunnelServer;
import org.apache.seatunnel.engine.server.resourcemanager.resource.SlotProfile;
import org.apache.seatunnel.engine.server.serializable.ResourceDataSerializerHook;
import org.apache.seatunnel.engine.server.service.slot.WrongTargetSlotException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReleaseSlotOperation
extends Operation
implements IdentifiedDataSerializable {
    private static final Logger log = LoggerFactory.getLogger(ReleaseSlotOperation.class);
    private long jobID;
    private SlotProfile slotProfile;

    public ReleaseSlotOperation() {
    }

    public ReleaseSlotOperation(long jobID, SlotProfile slotProfile) {
        this.jobID = jobID;
        this.slotProfile = slotProfile;
    }

    @Override
    public void run() throws Exception {
        SeaTunnelServer server = (SeaTunnelServer)this.getService();
        try {
            server.getSlotService().releaseSlot(this.jobID, this.slotProfile);
        }
        catch (WrongTargetSlotException ignore) {
            log.warn("wrong target release operation with job {} and slot profile {}", (Object)this.jobID, (Object)this.slotProfile);
        }
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        out.writeObject(this.slotProfile);
        out.writeLong(this.jobID);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        this.slotProfile = (SlotProfile)in.readObject();
        this.jobID = in.readLong();
    }

    @Override
    public String getServiceName() {
        return "st:impl:seaTunnelServer";
    }

    @Override
    public int getFactoryId() {
        return ResourceDataSerializerHook.FACTORY_ID;
    }

    @Override
    public int getClassId() {
        return 3;
    }
}

