/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.task.context;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.seatunnel.api.common.metrics.MetricsContext;
import org.apache.seatunnel.api.event.EventListener;
import org.apache.seatunnel.api.source.SourceEvent;
import org.apache.seatunnel.api.source.SourceSplit;
import org.apache.seatunnel.api.source.SourceSplitEnumerator;
import org.apache.seatunnel.engine.common.utils.ExceptionUtil;
import org.apache.seatunnel.engine.server.task.SourceSplitEnumeratorTask;
import org.apache.seatunnel.engine.server.task.operation.source.AssignSplitOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SeaTunnelSplitEnumeratorContext<SplitT extends SourceSplit>
implements SourceSplitEnumerator.Context<SplitT> {
    private static final Logger log = LoggerFactory.getLogger(SeaTunnelSplitEnumeratorContext.class);
    private final int parallelism;
    private final SourceSplitEnumeratorTask<SplitT> task;
    private final MetricsContext metricsContext;
    private final EventListener eventListener;

    public SeaTunnelSplitEnumeratorContext(int parallelism, SourceSplitEnumeratorTask<SplitT> task, MetricsContext metricsContext, EventListener eventListener) {
        this.parallelism = parallelism;
        this.task = task;
        this.metricsContext = metricsContext;
        this.eventListener = eventListener;
    }

    @Override
    public int currentParallelism() {
        return this.parallelism;
    }

    @Override
    public Set<Integer> registeredReaders() {
        return new HashSet<Integer>(this.task.getRegisteredReaders());
    }

    @Override
    public void assignSplit(int subtaskIndex, List<SplitT> splits) {
        if (this.registeredReaders().isEmpty()) {
            log.warn("No reader is obtained, skip this assign!");
            return;
        }
        List<byte[]> splitBytes = splits.stream().map(split -> ExceptionUtil.sneaky(() -> this.task.getSplitSerializer().serialize(split))).collect(Collectors.toList());
        this.task.getExecutionContext().sendToMember(new AssignSplitOperation(this.task.getTaskMemberLocationByIndex(subtaskIndex), splitBytes), this.task.getTaskMemberAddressByIndex(subtaskIndex)).join();
    }

    @Override
    public void signalNoMoreSplits(int subtaskIndex) {
        List<byte[]> emptySplits = Collections.emptyList();
        this.task.getExecutionContext().sendToMember(new AssignSplitOperation(this.task.getTaskMemberLocationByIndex(subtaskIndex), emptySplits), this.task.getTaskMemberAddressByIndex(subtaskIndex)).join();
    }

    @Override
    public void sendEventToSourceReader(int subtaskId, SourceEvent event) {
    }

    @Override
    public MetricsContext getMetricsContext() {
        return this.metricsContext;
    }

    @Override
    public EventListener getEventListener() {
        return this.eventListener;
    }
}

