/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.api.source.event;

import org.apache.seatunnel.api.event.Event;
import org.apache.seatunnel.api.event.EventType;

public class MessageDelayedEvent
implements Event {
    private long createdTime;
    private String jobId;
    private EventType eventType = EventType.READER_MESSAGE_DELAYED;
    private long delayTime;
    private String record;

    public MessageDelayedEvent(long delayTime) {
        this(delayTime, null);
    }

    public MessageDelayedEvent(long delayTime, String record) {
        this.delayTime = delayTime;
        this.record = record;
        this.createdTime = System.currentTimeMillis();
    }

    @Override
    public long getCreatedTime() {
        return this.createdTime;
    }

    @Override
    public String getJobId() {
        return this.jobId;
    }

    @Override
    public EventType getEventType() {
        return this.eventType;
    }

    public long getDelayTime() {
        return this.delayTime;
    }

    public String getRecord() {
        return this.record;
    }

    public void setCreatedTime(long createdTime) {
        this.createdTime = createdTime;
    }

    @Override
    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public void setEventType(EventType eventType) {
        this.eventType = eventType;
    }

    public void setDelayTime(long delayTime) {
        this.delayTime = delayTime;
    }

    public void setRecord(String record) {
        this.record = record;
    }

    public String toString() {
        return "MessageDelayedEvent(createdTime=" + this.getCreatedTime() + ", jobId=" + this.getJobId() + ", eventType=" + (Object)((Object)this.getEventType()) + ", delayTime=" + this.getDelayTime() + ", record=" + this.getRecord() + ")";
    }

    public MessageDelayedEvent(long createdTime, String jobId, EventType eventType, long delayTime, String record) {
        this.createdTime = createdTime;
        this.jobId = jobId;
        this.eventType = eventType;
        this.delayTime = delayTime;
        this.record = record;
    }

    public MessageDelayedEvent() {
    }
}

