/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.event;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.impl.operationservice.Operation;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.List;
import org.apache.seatunnel.api.event.Event;
import org.apache.seatunnel.api.event.EventProcessor;
import org.apache.seatunnel.engine.server.SeaTunnelServer;
import org.apache.seatunnel.engine.server.serializable.TaskDataSerializerHook;

public class JobEventReportOperation
extends Operation
implements IdentifiedDataSerializable {
    private List<Event> events;

    @Override
    public void run() throws Exception {
        SeaTunnelServer server = (SeaTunnelServer)this.getService();
        EventProcessor processor = server.getCoordinatorService().getEventProcessor();
        for (Event event : this.events) {
            processor.process(event);
        }
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        try (ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
             ObjectOutputStream objectOut = new ObjectOutputStream(byteOut);){
            objectOut.writeObject(this.events);
            objectOut.flush();
            out.writeByteArray(byteOut.toByteArray());
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        try (ByteArrayInputStream byteIn = new ByteArrayInputStream(in.readByteArray());
             ObjectInputStream objectIn = new ObjectInputStream(byteIn);){
            this.events = (List)objectIn.readObject();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int getFactoryId() {
        return TaskDataSerializerHook.FACTORY_ID;
    }

    @Override
    public int getClassId() {
        return 25;
    }

    public JobEventReportOperation() {
    }

    public JobEventReportOperation(List<Event> events) {
        this.events = events;
    }
}

