/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.com.fasterxml.jackson.jr.type;

import com.hazelcast.com.fasterxml.jackson.jr.ob.impl.ClassKey;
import com.hazelcast.com.fasterxml.jackson.jr.type.ClassStack;
import com.hazelcast.com.fasterxml.jackson.jr.type.RecursiveType;
import com.hazelcast.com.fasterxml.jackson.jr.type.ResolvedType;
import com.hazelcast.com.fasterxml.jackson.jr.type.TypeBindings;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.HashMap;
import java.util.Map;

public class TypeResolver
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final ResolvedType[] NO_TYPES;
    private static final ResolvedType TYPE_OBJECT;
    private static final HashMap<ClassKey, ResolvedType> _primitives;
    protected final transient Map<ClassKey, ResolvedType> _cache = new HashMap<ClassKey, ResolvedType>(16, 0.8f);

    protected Object readResolve() {
        if (this._cache == null) {
            return new TypeResolver();
        }
        return this;
    }

    public ResolvedType resolve(TypeBindings typeBindings, Type type) {
        return this._fromAny(null, type, typeBindings);
    }

    private ResolvedType _fromAny(ClassStack classStack, Type type, TypeBindings typeBindings) {
        if (type instanceof Class) {
            return this._fromClass(classStack, (Class)type, typeBindings);
        }
        if (type instanceof ResolvedType) {
            return (ResolvedType)type;
        }
        if (type instanceof ParameterizedType) {
            return this._fromParamType(classStack, (ParameterizedType)type, typeBindings);
        }
        if (type instanceof GenericArrayType) {
            ResolvedType resolvedType = this._fromAny(classStack, ((GenericArrayType)type).getGenericComponentType(), typeBindings);
            Object object = Array.newInstance(resolvedType.erasedType(), 0);
            return new ResolvedType(object.getClass(), typeBindings, resolvedType);
        }
        if (type instanceof TypeVariable) {
            return this._fromVariable(classStack, (TypeVariable)type, typeBindings);
        }
        if (type instanceof WildcardType) {
            return this._fromAny(classStack, ((WildcardType)type).getUpperBounds()[0], typeBindings);
        }
        throw new IllegalArgumentException("Unrecognized type class: " + type.getClass().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResolvedType _fromClass(ClassStack classStack, Class<?> clazz, TypeBindings typeBindings) {
        Object object;
        ClassKey classKey = new ClassKey(clazz, 0);
        if (clazz.isPrimitive() && (object = _primitives.get(classKey)) != null) {
            return object;
        }
        if (classStack == null) {
            classStack = new ClassStack(clazz);
        } else {
            object = classStack.find(clazz);
            if (object != null) {
                RecursiveType recursiveType = new RecursiveType(clazz, typeBindings);
                ((ClassStack)object).addSelfReference(recursiveType);
                return recursiveType;
            }
            classStack = classStack.child(clazz);
        }
        if (typeBindings.isEmpty()) {
            Map<ClassKey, ResolvedType> map = this._cache;
            synchronized (map) {
                object = this._cache.get(classKey);
                if (object != null) {
                    return object;
                }
            }
            object = this._constructType(classStack, clazz, typeBindings);
            map = this._cache;
            synchronized (map) {
                if (this._cache.size() >= 100) {
                    this._cache.clear();
                }
                this._cache.put(classKey, (ResolvedType)object);
            }
        }
        object = this._constructType(classStack, clazz, typeBindings);
        classStack.resolveSelfReferences((ResolvedType)object);
        return object;
    }

    private ResolvedType _constructType(ClassStack classStack, Class<?> clazz, TypeBindings typeBindings) {
        if (clazz.isArray()) {
            ResolvedType resolvedType = this._fromAny(classStack, clazz.getComponentType(), typeBindings);
            return new ResolvedType(clazz, typeBindings, resolvedType);
        }
        if (clazz.isInterface()) {
            return new ResolvedType(clazz, typeBindings, this._resolveSuperInterfaces(classStack, clazz, typeBindings));
        }
        return new ResolvedType(clazz, this._resolveSuperClass(classStack, clazz, typeBindings), typeBindings, this._resolveSuperInterfaces(classStack, clazz, typeBindings));
    }

    private ResolvedType[] _resolveSuperInterfaces(ClassStack classStack, Class<?> clazz, TypeBindings typeBindings) {
        Type[] typeArray = clazz.getGenericInterfaces();
        if (typeArray == null || typeArray.length == 0) {
            return NO_TYPES;
        }
        int n = typeArray.length;
        ResolvedType[] resolvedTypeArray = new ResolvedType[n];
        for (int i = 0; i < n; ++i) {
            resolvedTypeArray[i] = this._fromAny(classStack, typeArray[i], typeBindings);
        }
        return resolvedTypeArray;
    }

    private ResolvedType _resolveSuperClass(ClassStack classStack, Class<?> clazz, TypeBindings typeBindings) {
        Type type = clazz.getGenericSuperclass();
        if (type == null) {
            return null;
        }
        return this._fromAny(classStack, type, typeBindings);
    }

    private ResolvedType _fromParamType(ClassStack classStack, ParameterizedType parameterizedType, TypeBindings typeBindings) {
        Class clazz = (Class)parameterizedType.getRawType();
        Type[] typeArray = parameterizedType.getActualTypeArguments();
        int n = typeArray.length;
        ResolvedType[] resolvedTypeArray = new ResolvedType[n];
        for (int i = 0; i < n; ++i) {
            resolvedTypeArray[i] = this._fromAny(classStack, typeArray[i], typeBindings);
        }
        TypeBindings typeBindings2 = TypeBindings.create(clazz, resolvedTypeArray);
        return this._fromClass(classStack, clazz, typeBindings2);
    }

    private ResolvedType _fromVariable(ClassStack classStack, TypeVariable<?> typeVariable, TypeBindings typeBindings) {
        String string = typeVariable.getName();
        ResolvedType resolvedType = typeBindings.findBoundType(string);
        if (resolvedType != null) {
            return resolvedType;
        }
        if (typeBindings.hasUnbound(string)) {
            return TYPE_OBJECT;
        }
        typeBindings = typeBindings.withUnboundVariable(string);
        Type[] typeArray = typeVariable.getBounds();
        return this._fromAny(classStack, typeArray[0], typeBindings);
    }

    static {
        ResolvedType[] resolvedTypeArray;
        NO_TYPES = new ResolvedType[0];
        TYPE_OBJECT = new ResolvedType(Object.class, null, null, null);
        _primitives = new HashMap(16);
        for (ResolvedType resolvedType : resolvedTypeArray = new ResolvedType[]{new ResolvedType(Boolean.TYPE), new ResolvedType(Byte.TYPE), new ResolvedType(Short.TYPE), new ResolvedType(Character.TYPE), new ResolvedType(Integer.TYPE), new ResolvedType(Long.TYPE), new ResolvedType(Float.TYPE), new ResolvedType(Double.TYPE)}) {
            _primitives.put(new ClassKey(resolvedType.erasedType(), 0), resolvedType);
        }
        _primitives.put(new ClassKey(Void.TYPE, 0), new ResolvedType(Void.TYPE));
        _primitives.put(new ClassKey(Object.class, 0), TYPE_OBJECT);
    }
}

