/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.api.sink.multitablesink;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.seatunnel.api.sink.MultiTableResourceManager;
import org.apache.seatunnel.api.sink.SinkWriter;
import org.apache.seatunnel.api.sink.SupportMultiTableSinkWriter;
import org.apache.seatunnel.api.sink.multitablesink.MultiTableCommitInfo;
import org.apache.seatunnel.api.sink.multitablesink.MultiTableState;
import org.apache.seatunnel.api.sink.multitablesink.MultiTableWriterRunnable;
import org.apache.seatunnel.api.sink.multitablesink.SinkIdentifier;
import org.apache.seatunnel.api.table.event.SchemaChangeEvent;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiTableSinkWriter
implements SinkWriter<SeaTunnelRow, MultiTableCommitInfo, MultiTableState> {
    private static final Logger log = LoggerFactory.getLogger(MultiTableSinkWriter.class);
    private final Map<SinkIdentifier, SinkWriter<SeaTunnelRow, ?, ?>> sinkWriters;
    private final Map<String, Optional<Integer>> sinkPrimaryKeys = new HashMap<String, Optional<Integer>>();
    private final List<Map<SinkIdentifier, SinkWriter<SeaTunnelRow, ?, ?>>> sinkWritersWithIndex;
    private final List<MultiTableWriterRunnable> runnable = new ArrayList<MultiTableWriterRunnable>();
    private final Random random = new Random();
    private final List<BlockingQueue<SeaTunnelRow>> blockingQueues = new ArrayList<BlockingQueue<SeaTunnelRow>>();
    private final ExecutorService executorService;
    private MultiTableResourceManager resourceManager;
    private volatile boolean submitted = false;

    public MultiTableSinkWriter(Map<SinkIdentifier, SinkWriter<SeaTunnelRow, ?, ?>> sinkWriters, int queueSize) {
        this.sinkWriters = sinkWriters;
        AtomicInteger cnt = new AtomicInteger(0);
        this.executorService = Executors.newFixedThreadPool(queueSize * 2, runnable -> {
            Thread thread = new Thread(runnable);
            thread.setDaemon(true);
            thread.setName("st-multi-table-sink-writer-" + cnt.incrementAndGet());
            return thread;
        });
        this.sinkWritersWithIndex = new ArrayList();
        int i = 0;
        while (i < queueSize) {
            LinkedBlockingQueue<SeaTunnelRow> queue = new LinkedBlockingQueue<SeaTunnelRow>(1024);
            HashMap tableIdWriterMap = new HashMap();
            HashMap sinkIdentifierMap = new HashMap();
            int queueIndex = i++;
            sinkWriters.entrySet().stream().filter(entry -> ((SinkIdentifier)entry.getKey()).getIndex() % queueSize == queueIndex).forEach(entry -> {
                tableIdWriterMap.put(((SinkIdentifier)entry.getKey()).getTableIdentifier(), (SinkWriter)entry.getValue());
                sinkIdentifierMap.put((SinkIdentifier)entry.getKey(), (SinkWriter)entry.getValue());
            });
            this.sinkWritersWithIndex.add(sinkIdentifierMap);
            this.blockingQueues.add(queue);
            MultiTableWriterRunnable r = new MultiTableWriterRunnable(tableIdWriterMap, queue);
            this.runnable.add(r);
        }
        log.info("init multi table sink writer, queue size: {}", (Object)queueSize);
        this.initResourceManager(queueSize);
    }

    private void initResourceManager(int queueSize) {
        Iterator<SinkIdentifier> iterator = this.sinkWriters.keySet().iterator();
        if (iterator.hasNext()) {
            SinkIdentifier tableIdentifier = iterator.next();
            SinkWriter<SeaTunnelRow, ?, ?> sink = this.sinkWriters.get(tableIdentifier);
            this.resourceManager = ((SupportMultiTableSinkWriter)((Object)sink)).initMultiTableResourceManager(this.sinkWriters.size(), queueSize);
        }
        for (int i = 0; i < this.sinkWritersWithIndex.size(); ++i) {
            Map<SinkIdentifier, SinkWriter<SeaTunnelRow, ?, ?>> writerMap = this.sinkWritersWithIndex.get(i);
            for (Map.Entry<SinkIdentifier, SinkWriter<SeaTunnelRow, ?, ?>> entry : writerMap.entrySet()) {
                SupportMultiTableSinkWriter sink = (SupportMultiTableSinkWriter)((Object)entry.getValue());
                sink.setMultiTableResourceManager(this.resourceManager, i);
                this.sinkPrimaryKeys.put(entry.getKey().getTableIdentifier(), sink.primaryKey());
            }
        }
    }

    private void subSinkErrorCheck() {
        for (MultiTableWriterRunnable writerRunnable : this.runnable) {
            if (writerRunnable.getThrowable() == null) continue;
            throw new RuntimeException(writerRunnable.getThrowable());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void applySchemaChange(SchemaChangeEvent event) throws IOException {
        this.subSinkErrorCheck();
        for (int i = 0; i < this.sinkWritersWithIndex.size(); ++i) {
            for (Map.Entry<SinkIdentifier, SinkWriter<SeaTunnelRow, ?, ?>> sinkWriterEntry : this.sinkWritersWithIndex.get(i).entrySet()) {
                if (!sinkWriterEntry.getKey().getTableIdentifier().equals(event.tablePath().getFullName())) continue;
                MultiTableWriterRunnable multiTableWriterRunnable = this.runnable.get(i);
                synchronized (multiTableWriterRunnable) {
                    sinkWriterEntry.getValue().applySchemaChange(event);
                }
            }
        }
    }

    @Override
    public void write(SeaTunnelRow element) throws IOException {
        if (!this.submitted) {
            this.submitted = true;
            this.runnable.forEach(this.executorService::submit);
        }
        this.subSinkErrorCheck();
        Optional<Integer> primaryKey = this.sinkPrimaryKeys.get(element.getTableId());
        try {
            if (primaryKey == null && this.sinkPrimaryKeys.size() == 1 || primaryKey != null && !primaryKey.isPresent()) {
                int index = this.random.nextInt(this.blockingQueues.size());
                BlockingQueue<SeaTunnelRow> queue = this.blockingQueues.get(index);
                while (!queue.offer(element, 500L, TimeUnit.MILLISECONDS)) {
                    this.subSinkErrorCheck();
                }
            } else {
                if (primaryKey == null) {
                    throw new RuntimeException("multi table sink can not write table: " + element.getTableId());
                }
                Object object = element.getField(primaryKey.get());
                int index = 0;
                if (object != null) {
                    index = Math.abs(object.hashCode()) % this.blockingQueues.size();
                }
                BlockingQueue<SeaTunnelRow> queue = this.blockingQueues.get(index);
                while (!queue.offer(element, 500L, TimeUnit.MILLISECONDS)) {
                    this.subSinkErrorCheck();
                }
            }
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<MultiTableState> snapshotState(long checkpointId) throws IOException {
        this.checkQueueRemain();
        this.subSinkErrorCheck();
        ArrayList<MultiTableState> multiTableStates = new ArrayList<MultiTableState>();
        MultiTableState multiTableState = new MultiTableState(new HashMap());
        for (int i = 0; i < this.sinkWritersWithIndex.size(); ++i) {
            for (Map.Entry<SinkIdentifier, SinkWriter<SeaTunnelRow, ?, ?>> sinkWriterEntry : this.sinkWritersWithIndex.get(i).entrySet()) {
                MultiTableWriterRunnable multiTableWriterRunnable = this.runnable.get(i);
                synchronized (multiTableWriterRunnable) {
                    List<?> states = sinkWriterEntry.getValue().snapshotState(checkpointId);
                    multiTableState.getStates().put(sinkWriterEntry.getKey(), states);
                }
            }
        }
        multiTableStates.add(multiTableState);
        return multiTableStates;
    }

    @Override
    public Optional<MultiTableCommitInfo> prepareCommit() throws IOException {
        this.checkQueueRemain();
        this.subSinkErrorCheck();
        MultiTableCommitInfo multiTableCommitInfo = new MultiTableCommitInfo(new HashMap<SinkIdentifier, Object>());
        ArrayList futures = new ArrayList();
        int i = 0;
        while (i < this.sinkWritersWithIndex.size()) {
            int n = i++;
            futures.add(this.executorService.submit(() -> {
                MultiTableWriterRunnable multiTableWriterRunnable = this.runnable.get(subWriterIndex);
                synchronized (multiTableWriterRunnable) {
                    for (Map.Entry<SinkIdentifier, SinkWriter<SeaTunnelRow, ?, ?>> sinkWriterEntry : this.sinkWritersWithIndex.get(subWriterIndex).entrySet()) {
                        Optional<?> commit;
                        try {
                            commit = sinkWriterEntry.getValue().prepareCommit();
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                        commit.ifPresent(o -> multiTableCommitInfo.getCommitInfo().put((SinkIdentifier)sinkWriterEntry.getKey(), o));
                    }
                }
            }));
        }
        for (Future future : futures) {
            try {
                future.get();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return Optional.of(multiTableCommitInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abortPrepare() {
        Throwable firstE = null;
        try {
            this.checkQueueRemain();
        }
        catch (Exception e) {
            firstE = e;
        }
        for (int i = 0; i < this.sinkWritersWithIndex.size(); ++i) {
            MultiTableWriterRunnable multiTableWriterRunnable = this.runnable.get(i);
            synchronized (multiTableWriterRunnable) {
                for (SinkWriter<SeaTunnelRow, ?, ?> sinkWriter : this.sinkWritersWithIndex.get(i).values()) {
                    try {
                        sinkWriter.abortPrepare();
                    }
                    catch (Throwable e) {
                        if (firstE == null) {
                            firstE = e;
                        }
                        log.error("abortPrepare error", e);
                    }
                }
                continue;
            }
        }
        if (firstE != null) {
            throw new RuntimeException(firstE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Throwable firstE = null;
        try {
            this.checkQueueRemain();
        }
        catch (Exception e) {
            firstE = e;
        }
        this.executorService.shutdownNow();
        for (int i = 0; i < this.sinkWritersWithIndex.size(); ++i) {
            MultiTableWriterRunnable multiTableWriterRunnable = this.runnable.get(i);
            synchronized (multiTableWriterRunnable) {
                for (SinkWriter<SeaTunnelRow, ?, ?> sinkWriter : this.sinkWritersWithIndex.get(i).values()) {
                    try {
                        sinkWriter.close();
                    }
                    catch (Throwable e) {
                        if (firstE == null) {
                            firstE = e;
                        }
                        log.error("close error", e);
                    }
                }
                continue;
            }
        }
        try {
            if (this.resourceManager != null) {
                this.resourceManager.close();
            }
        }
        catch (Throwable e) {
            log.error("close resourceManager error", e);
        }
        if (firstE != null) {
            throw new RuntimeException(firstE);
        }
    }

    private void checkQueueRemain() {
        try {
            for (BlockingQueue<SeaTunnelRow> blockingQueue : this.blockingQueues) {
                while (!blockingQueue.isEmpty()) {
                    Thread.sleep(100L);
                    this.subSinkErrorCheck();
                }
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }
}

