/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.fake.source;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.stream.Collectors;
import org.apache.seatunnel.api.event.Event;
import org.apache.seatunnel.api.source.Boundedness;
import org.apache.seatunnel.api.source.Collector;
import org.apache.seatunnel.api.source.SourceReader;
import org.apache.seatunnel.api.source.event.ReaderCloseEvent;
import org.apache.seatunnel.api.source.event.ReaderOpenEvent;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.connectors.seatunnel.fake.config.FakeConfig;
import org.apache.seatunnel.connectors.seatunnel.fake.config.MultipleTableFakeSourceConfig;
import org.apache.seatunnel.connectors.seatunnel.fake.source.FakeDataGenerator;
import org.apache.seatunnel.connectors.seatunnel.fake.source.FakeSourceSplit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FakeSourceReader
implements SourceReader<SeaTunnelRow, FakeSourceSplit> {
    private static final Logger log = LoggerFactory.getLogger(FakeSourceReader.class);
    private final SourceReader.Context context;
    private final Deque<FakeSourceSplit> splits = new ConcurrentLinkedDeque<FakeSourceSplit>();
    private final MultipleTableFakeSourceConfig multipleTableFakeSourceConfig;
    private final Map<String, FakeDataGenerator> fakeDataGeneratorMap;
    private volatile boolean noMoreSplit;
    private final long minSplitReadInterval;
    private volatile long latestTimestamp = 0L;

    public FakeSourceReader(SourceReader.Context context, MultipleTableFakeSourceConfig multipleTableFakeSourceConfig) {
        this.context = context;
        this.multipleTableFakeSourceConfig = multipleTableFakeSourceConfig;
        this.fakeDataGeneratorMap = multipleTableFakeSourceConfig.getFakeConfigs().stream().collect(Collectors.toMap(fakeConfig -> fakeConfig.getCatalogTable().getTableId().toTablePath().toString(), FakeDataGenerator::new));
        this.minSplitReadInterval = multipleTableFakeSourceConfig.getFakeConfigs().stream().map(FakeConfig::getSplitReadInterval).min(Integer::compareTo).get().intValue();
    }

    public void open() {
        this.context.getEventListener().onEvent((Event)new ReaderOpenEvent());
    }

    public void close() {
        this.context.getEventListener().onEvent((Event)new ReaderCloseEvent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pollNext(Collector<SeaTunnelRow> output) throws InterruptedException {
        long currentTimestamp = Instant.now().toEpochMilli();
        if (currentTimestamp <= this.latestTimestamp + this.minSplitReadInterval) {
            return;
        }
        this.latestTimestamp = currentTimestamp;
        Object object = output.getCheckpointLock();
        synchronized (object) {
            FakeSourceSplit split = this.splits.poll();
            if (null != split) {
                FakeDataGenerator fakeDataGenerator = this.fakeDataGeneratorMap.get(split.getTableId());
                List<SeaTunnelRow> seaTunnelRows = fakeDataGenerator.generateFakedRows(split.getRowNum());
                seaTunnelRows.forEach(arg_0 -> output.collect(arg_0));
                log.info("{} rows of data have been generated in split({}) for table {}. Generation time: {}", new Object[]{seaTunnelRows.size(), split.splitId(), split.getTableId(), this.latestTimestamp});
            } else if (!this.noMoreSplit) {
                log.info("wait split!");
            }
        }
        if (this.noMoreSplit && this.splits.isEmpty() && Boundedness.BOUNDED.equals((Object)this.context.getBoundedness())) {
            log.info("Closed the bounded fake source");
            this.context.signalNoMoreElement();
        }
        Thread.sleep(1000L);
    }

    public List<FakeSourceSplit> snapshotState(long checkpointId) throws Exception {
        return new ArrayList<FakeSourceSplit>(this.splits);
    }

    public void addSplits(List<FakeSourceSplit> splits) {
        log.debug("reader {} add splits {}", (Object)this.context.getIndexOfSubtask(), splits);
        this.splits.addAll(splits);
    }

    public void handleNoMoreSplits() {
        this.noMoreSplit = true;
    }

    public void notifyCheckpointComplete(long checkpointId) throws Exception {
    }
}

