/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.transform.llm;

import com.google.auto.service.AutoService;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.util.OptionRule;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.connector.TableTransform;
import org.apache.seatunnel.api.table.factory.Factory;
import org.apache.seatunnel.api.table.factory.TableTransformFactory;
import org.apache.seatunnel.api.table.factory.TableTransformFactoryContext;
import org.apache.seatunnel.transform.llm.LLMTransform;
import org.apache.seatunnel.transform.llm.LLMTransformConfig;
import org.apache.seatunnel.transform.llm.ModelProvider;

@AutoService(value={Factory.class})
public class LLMTransformFactory
implements TableTransformFactory {
    public String factoryIdentifier() {
        return "LLM";
    }

    public OptionRule optionRule() {
        return OptionRule.builder().required(new Option[]{LLMTransformConfig.MODEL_PROVIDER, LLMTransformConfig.MODEL, LLMTransformConfig.PROMPT, LLMTransformConfig.API_KEY}).optional(new Option[]{LLMTransformConfig.OUTPUT_DATA_TYPE, LLMTransformConfig.INFERENCE_BATCH_SIZE}).conditional(LLMTransformConfig.MODEL_PROVIDER, (Object)ModelProvider.OPENAI, new Option[]{LLMTransformConfig.OPENAI_API_PATH}).build();
    }

    public TableTransform createTransform(TableTransformFactoryContext context) {
        CatalogTable catalogTable = (CatalogTable)context.getCatalogTables().get(0);
        return () -> new LLMTransform(context.getOptions(), catalogTable);
    }
}

