/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.api.configuration;

import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.util.ConfigUtil;
import org.apache.seatunnel.shade.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.seatunnel.shade.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigFactory;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigRenderOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadonlyConfig
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(ReadonlyConfig.class);
    private static final long serialVersionUID = 1L;
    private static final ObjectMapper JACKSON_MAPPER = new ObjectMapper();
    protected final Map<String, Object> confData;

    private ReadonlyConfig(Map<String, Object> confData) {
        this.confData = confData;
    }

    public static ReadonlyConfig fromMap(Map<String, Object> map) {
        return new ReadonlyConfig(map);
    }

    public static ReadonlyConfig fromConfig(Config config) {
        try {
            return ReadonlyConfig.fromMap(JACKSON_MAPPER.readValue(config.root().render(ConfigRenderOptions.concise()), new TypeReference<Map<String, Object>>(){}));
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Json parsing exception.", e);
        }
    }

    public <T> T get(Option<T> option) {
        return (T)this.getOptional(option).orElseGet(option::defaultValue);
    }

    @Deprecated
    public Config toConfig() {
        return ConfigFactory.parseMap(this.confData);
    }

    public Map<String, String> toMap() {
        if (this.confData.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        this.toMap(result);
        return result;
    }

    public void toMap(Map<String, String> result) {
        if (this.confData.isEmpty()) {
            return;
        }
        for (Map.Entry<String, Object> entry : this.confData.entrySet()) {
            result.put(entry.getKey(), ConfigUtil.convertToJsonString(entry.getValue()));
        }
    }

    public Map<String, Object> getSourceMap() {
        return this.confData;
    }

    public <T> Optional<T> getOptional(Option<T> option) {
        if (option == null) {
            throw new NullPointerException("Option not be null.");
        }
        Object value = this.getValue(option.key());
        if (value == null) {
            for (String fallbackKey : option.getFallbackKeys()) {
                value = this.getValue(fallbackKey);
                if (value == null) continue;
                log.warn("Please use the new key '{}' instead of the deprecated key '{}'.", (Object)option.key(), (Object)fallbackKey);
                break;
            }
        }
        if (value == null) {
            return Optional.empty();
        }
        return Optional.of(ConfigUtil.convertValue(value, option));
    }

    private Object getValue(String key) {
        if (this.confData.containsKey(key)) {
            return this.confData.get(key);
        }
        String[] keys = key.split("\\.");
        Map data = this.confData;
        Object value = null;
        for (int i = 0; i < keys.length; ++i) {
            value = data.get(keys[i]);
            if (i >= keys.length - 1) continue;
            if (!(value instanceof Map)) {
                return null;
            }
            data = (Map)value;
        }
        return value;
    }

    public int hashCode() {
        int hash = 0;
        for (String s2 : this.confData.keySet()) {
            hash ^= s2.hashCode();
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ReadonlyConfig)) {
            return false;
        }
        Map<String, Object> otherConf = ((ReadonlyConfig)obj).confData;
        return this.confData.equals(otherConf);
    }

    public String toString() {
        return ConfigUtil.convertToJsonString(this.confData);
    }
}

