/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.execution;

import java.util.Collection;
import org.apache.seatunnel.engine.server.execution.Task;
import org.apache.seatunnel.engine.server.execution.TaskGroup;
import org.apache.seatunnel.engine.server.execution.TaskGroupDefaultImpl;
import org.apache.seatunnel.engine.server.execution.TaskGroupLocation;
import org.apache.seatunnel.engine.server.execution.TaskGroupType;
import org.apache.seatunnel.engine.server.task.group.TaskGroupWithIntermediateBlockingQueue;
import org.apache.seatunnel.engine.server.task.group.TaskGroupWithIntermediateDisruptor;

public class TaskGroupUtils {
    public static TaskGroup createTaskGroup(TaskGroupType type, TaskGroupLocation taskGroupLocation, String taskGroupName, Collection<Task> tasks) {
        switch (type) {
            case DEFAULT: {
                return new TaskGroupDefaultImpl(taskGroupLocation, taskGroupName, tasks);
            }
            case INTERMEDIATE_BLOCKING_QUEUE: {
                return new TaskGroupWithIntermediateBlockingQueue(taskGroupLocation, taskGroupName, tasks);
            }
            case INTERMEDIATE_DISRUPTOR_QUEUE: {
                return new TaskGroupWithIntermediateDisruptor(taskGroupLocation, taskGroupName, tasks);
            }
        }
        throw new IllegalArgumentException("Unsupported task group type: " + (Object)((Object)type));
    }
}

