/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.task.operation.source;

import org.apache.seatunnel.api.source.SourceEvent;
import org.apache.seatunnel.common.utils.RetryUtils;
import org.apache.seatunnel.common.utils.SerializationUtils;
import org.apache.seatunnel.engine.server.SeaTunnelServer;
import org.apache.seatunnel.engine.server.exception.TaskGroupContextNotFoundException;
import org.apache.seatunnel.engine.server.execution.TaskLocation;
import org.apache.seatunnel.engine.server.task.SourceSplitEnumeratorTask;
import org.apache.seatunnel.engine.server.task.operation.source.SourceEventOperation;

public class SourceReaderEventOperation
extends SourceEventOperation {
    public SourceReaderEventOperation() {
    }

    public SourceReaderEventOperation(TaskLocation targetTaskLocation, TaskLocation currentTaskLocation, SourceEvent event) {
        super(targetTaskLocation, currentTaskLocation, event);
    }

    @Override
    public int getClassId() {
        return 20;
    }

    @Override
    public void runInternal() throws Exception {
        SeaTunnelServer server = (SeaTunnelServer)this.getService();
        RetryUtils.retryWithException(() -> {
            SourceSplitEnumeratorTask task = (SourceSplitEnumeratorTask)server.getTaskExecutionService().getTask(this.taskLocation);
            ClassLoader classLoader = server.getTaskExecutionService().getExecutionContext(this.taskLocation.getTaskGroupLocation()).getClassLoader(task.getTaskID());
            task.handleSourceEvent(this.currentTaskLocation.getTaskIndex(), (SourceEvent)SerializationUtils.deserialize(this.sourceEvent, classLoader));
            return null;
        }, new RetryUtils.RetryMaterial(30, true, exception -> exception instanceof TaskGroupContextNotFoundException && !server.taskIsEnded(this.taskLocation.getTaskGroupLocation()), 2000L));
    }
}

