/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec.custom;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.ListMultiFrameCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import com.hazelcast.config.WanReplicationRef;
import java.util.List;

public final class WanReplicationRefCodec {
    private static final int REPUBLISHING_ENABLED_FIELD_OFFSET = 0;
    private static final int INITIAL_FRAME_SIZE = 1;

    private WanReplicationRefCodec() {
    }

    public static void encode(ClientMessage clientMessage, WanReplicationRef wanReplicationRef) {
        clientMessage.add(ClientMessage.BEGIN_FRAME.copy());
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[1]);
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 0, wanReplicationRef.isRepublishingEnabled());
        clientMessage.add(initialFrame);
        StringCodec.encode(clientMessage, wanReplicationRef.getName());
        StringCodec.encode(clientMessage, wanReplicationRef.getMergePolicyClassName());
        ListMultiFrameCodec.encodeNullable(clientMessage, wanReplicationRef.getFilters(), StringCodec::encode);
        clientMessage.add(ClientMessage.END_FRAME.copy());
    }

    public static WanReplicationRef decode(ClientMessage.ForwardFrameIterator iterator) {
        iterator.next();
        ClientMessage.Frame initialFrame = iterator.next();
        boolean republishingEnabled = FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 0);
        String name = StringCodec.decode(iterator);
        String mergePolicyClassName = StringCodec.decode(iterator);
        List<String> filters = ListMultiFrameCodec.decodeNullable(iterator, StringCodec::decode);
        CodecUtil.fastForwardToEndFrame(iterator);
        return new WanReplicationRef(name, mergePolicyClassName, filters, republishingEnabled);
    }
}

