/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.proxy;

import com.hazelcast.client.config.ClientFlakeIdGeneratorConfig;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.FlakeIdGeneratorNewIdBatchCodec;
import com.hazelcast.client.impl.spi.ClientContext;
import com.hazelcast.client.impl.spi.ClientProxy;
import com.hazelcast.client.impl.spi.impl.ClientInvocation;
import com.hazelcast.flakeidgen.FlakeIdGenerator;
import com.hazelcast.flakeidgen.impl.AutoBatcher;
import com.hazelcast.flakeidgen.impl.IdBatch;

public class ClientFlakeIdGeneratorProxy
extends ClientProxy
implements FlakeIdGenerator {
    private final AutoBatcher batcher;

    public ClientFlakeIdGeneratorProxy(String serviceName, String objectName, ClientContext context) {
        super(serviceName, objectName, context);
        ClientFlakeIdGeneratorConfig config = this.getContext().getClientConfig().findFlakeIdGeneratorConfig(this.getName());
        this.batcher = new AutoBatcher(config.getPrefetchCount(), config.getPrefetchValidityMillis(), this::newIdBatch);
    }

    @Override
    public long newId() {
        return this.batcher.newId();
    }

    private IdBatch newIdBatch(int batchSize) {
        ClientMessage requestMsg = FlakeIdGeneratorNewIdBatchCodec.encodeRequest(this.name, batchSize);
        ClientMessage responseMsg = (ClientMessage)new ClientInvocation(this.getClient(), requestMsg, this.getName()).invoke().joinInternal();
        FlakeIdGeneratorNewIdBatchCodec.ResponseParameters response = FlakeIdGeneratorNewIdBatchCodec.decodeResponse(responseMsg);
        return new IdBatch(response.base, response.increment, response.batchSize);
    }

    public String toString() {
        return "FlakeIdGenerator{name='" + this.name + "'}";
    }
}

