/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.serialization.impl.compact;

import com.hazelcast.internal.serialization.impl.compact.AbstractGenericRecordBuilder;
import com.hazelcast.internal.serialization.impl.compact.DeserializedGenericRecord;
import com.hazelcast.internal.serialization.impl.compact.Schema;
import com.hazelcast.nio.serialization.FieldKind;
import com.hazelcast.nio.serialization.GenericRecord;
import com.hazelcast.nio.serialization.GenericRecordBuilder;
import com.hazelcast.nio.serialization.HazelcastSerializationException;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.Nonnull;

public class DeserializedSchemaBoundGenericRecordBuilder
extends AbstractGenericRecordBuilder {
    private final TreeMap<String, Object> objects = new TreeMap();
    private final Schema schema;

    public DeserializedSchemaBoundGenericRecordBuilder(Schema schema) {
        this.schema = schema;
    }

    @Override
    @Nonnull
    public GenericRecord build() {
        Set<String> fieldNames = this.schema.getFieldNames();
        for (String fieldName : fieldNames) {
            if (this.objects.containsKey(fieldName)) continue;
            throw new HazelcastSerializationException("Found an unset field " + fieldName + ". All the fields must be set before build");
        }
        return new DeserializedGenericRecord(this.schema, this.objects);
    }

    @Override
    protected GenericRecordBuilder write(@Nonnull String fieldName, Object value, FieldKind fieldKind) {
        DeserializedSchemaBoundGenericRecordBuilder.checkTypeWithSchema(this.schema, fieldName, fieldKind);
        if (this.objects.putIfAbsent(fieldName, value) != null) {
            throw new HazelcastSerializationException("Field can only be written once");
        }
        return this;
    }
}

