/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.schema;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.sql.impl.SqlDataSerializerHook;
import com.hazelcast.sql.impl.schema.MappingField;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class Mapping
implements IdentifiedDataSerializable {
    private String name;
    private String externalName;
    private String type;
    private List<MappingField> mappingFields;
    private Map<String, String> options;

    public Mapping() {
    }

    public Mapping(String name, String externalName, String type, List<MappingField> fields, Map<String, String> options) {
        this.name = name;
        this.externalName = externalName;
        this.type = type;
        this.mappingFields = fields;
        this.options = options;
    }

    public String name() {
        return this.name;
    }

    public String externalName() {
        return this.externalName;
    }

    public String type() {
        return this.type;
    }

    public List<MappingField> fields() {
        return Collections.unmodifiableList(this.mappingFields);
    }

    public Map<String, String> options() {
        return Collections.unmodifiableMap(this.options);
    }

    @Override
    public int getFactoryId() {
        return SqlDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 57;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeString(this.name);
        out.writeString(this.externalName);
        out.writeString(this.type);
        out.writeObject(this.mappingFields);
        out.writeObject(this.options);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.name = in.readString();
        this.externalName = in.readString();
        this.type = in.readString();
        this.mappingFields = (List)in.readObject();
        this.options = (Map)in.readObject();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Mapping mapping = (Mapping)o;
        return Objects.equals(this.name, mapping.name) && Objects.equals(this.externalName, mapping.externalName) && Objects.equals(this.type, mapping.type) && Objects.equals(this.mappingFields, mapping.mappingFields) && Objects.equals(this.options, mapping.options);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.externalName, this.type, this.mappingFields, this.options);
    }
}

