/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.api.table.type;

import java.math.BigDecimal;
import java.util.Objects;
import org.apache.seatunnel.api.table.type.BasicType;
import org.apache.seatunnel.api.table.type.SqlType;

public final class DecimalType
extends BasicType<BigDecimal> {
    private static final long serialVersionUID = 1L;
    private final int precision;
    private final int scale;

    public DecimalType(int precision, int scale) {
        super(BigDecimal.class, SqlType.DECIMAL);
        this.precision = precision;
        this.scale = scale;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DecimalType)) {
            return false;
        }
        DecimalType that = (DecimalType)o;
        return this.precision == that.precision && this.scale == that.scale;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.precision, this.scale);
    }

    @Override
    public String toString() {
        return String.format("Decimal(%d, %d)", this.precision, this.scale);
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getScale() {
        return this.scale;
    }
}

