/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.schema.property;

import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.google.common.base.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;
import springfox.documentation.schema.configuration.ObjectMapperConfigured;
import springfox.documentation.schema.property.BeanPropertyDefinitions;
import springfox.documentation.schema.property.BeanPropertyNamingStrategy;

@Component
public class ObjectMapperBeanPropertyNamingStrategy
implements BeanPropertyNamingStrategy,
ApplicationListener<ObjectMapperConfigured> {
    private static final Logger LOG = LoggerFactory.getLogger(ObjectMapperBeanPropertyNamingStrategy.class);
    private ObjectMapper objectMapper;

    @Override
    public String nameForSerialization(BeanPropertyDefinition beanProperty) {
        SerializationConfig serializationConfig = this.objectMapper.getSerializationConfig();
        Optional namingStrategy = Optional.fromNullable((Object)serializationConfig.getPropertyNamingStrategy());
        String newName = (String)namingStrategy.transform(BeanPropertyDefinitions.overTheWireName(beanProperty, serializationConfig)).or((Object)beanProperty.getName());
        LOG.debug("Name '{}' renamed to '{}'", (Object)beanProperty.getName(), (Object)newName);
        return newName;
    }

    @Override
    public String nameForDeserialization(BeanPropertyDefinition beanProperty) {
        DeserializationConfig deserializationConfig = this.objectMapper.getDeserializationConfig();
        Optional namingStrategy = Optional.fromNullable((Object)deserializationConfig.getPropertyNamingStrategy());
        String newName = (String)namingStrategy.transform(BeanPropertyDefinitions.overTheWireName(beanProperty, deserializationConfig)).or((Object)beanProperty.getName());
        LOG.debug("Name '{}' renamed to '{}'", (Object)beanProperty.getName(), (Object)newName);
        return newName;
    }

    public void onApplicationEvent(ObjectMapperConfigured event) {
        this.objectMapper = event.getObjectMapper();
    }
}

