/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.app.common;

import org.apache.seatunnel.server.common.SeatunnelErrorEnum;
import org.apache.seatunnel.server.common.SeatunnelException;

public class Result<T> {
    private static final Result<Void> OK = Result.success();
    private int code = 0;
    private String msg;
    private T data;

    public Result() {
        this.data = null;
    }

    private Result(SeatunnelErrorEnum errorEnum) {
        this.code = errorEnum.getCode();
        this.msg = errorEnum.getMsg();
        this.data = null;
    }

    private Result(SeatunnelErrorEnum errorEnum, String ... messages) {
        this.code = errorEnum.getCode();
        this.msg = String.format(errorEnum.getTemplate(), messages);
        this.data = null;
    }

    private Result(SeatunnelException e) {
        this.code = e.getErrorEnum().getCode();
        this.msg = e.getMessage();
        this.data = null;
    }

    private Result(int code, String msg) {
        this.code = code;
        this.msg = msg;
        this.data = null;
    }

    public static <T> Result<T> success() {
        return new Result<T>();
    }

    public static <T> Result<T> success(T data) {
        Result<T> result = Result.success();
        result.setData(data);
        return result;
    }

    public static <T> Result<T> failure(SeatunnelErrorEnum errorEnum) {
        Result<T> result = new Result<T>(errorEnum);
        return result;
    }

    public static <T> Result<T> failure(SeatunnelErrorEnum errorEnum, String ... messages) {
        Result<T> result = new Result<T>(errorEnum, messages);
        return result;
    }

    public static <T> Result<T> failure(SeatunnelException e) {
        Result<T> result = new Result<T>(e);
        return result;
    }

    public static <T> Result<T> failure(int code, String msg) {
        Result<T> result = new Result<T>(code, msg);
        return result;
    }

    public boolean isSuccess() {
        return OK.getCode() == this.code;
    }

    public boolean isFailed() {
        return !this.isSuccess();
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }
}

