/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.core.spatialRddTool;

import java.io.Serializable;
import java.util.Objects;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;

public class StatCalculator
implements Serializable {
    private final Envelope boundary;
    private final long count;

    public StatCalculator(Envelope boundary, long count) {
        Objects.requireNonNull(boundary, "Boundary cannot be null");
        if (count <= 0L) {
            throw new IllegalArgumentException("Count must be > 0");
        }
        this.boundary = boundary;
        this.count = count;
    }

    public static StatCalculator combine(StatCalculator agg1, StatCalculator agg2) throws Exception {
        if (agg1 == null) {
            return agg2;
        }
        if (agg2 == null) {
            return agg1;
        }
        return new StatCalculator(StatCalculator.combine(agg1.boundary, agg2.boundary), agg1.count + agg2.count);
    }

    public static Envelope combine(Envelope agg1, Envelope agg2) throws Exception {
        if (agg1 == null) {
            return agg2;
        }
        if (agg2 == null) {
            return agg1;
        }
        return new Envelope(Math.min(agg1.getMinX(), agg2.getMinX()), Math.max(agg1.getMaxX(), agg2.getMaxX()), Math.min(agg1.getMinY(), agg2.getMinY()), Math.max(agg1.getMaxY(), agg2.getMaxY()));
    }

    public static Envelope add(Envelope agg, Geometry object) throws Exception {
        return StatCalculator.combine(object.getEnvelopeInternal(), agg);
    }

    public static StatCalculator add(StatCalculator agg, Geometry object) throws Exception {
        return StatCalculator.combine(new StatCalculator(object.getEnvelopeInternal(), 1L), agg);
    }

    public Envelope getBoundary() {
        return this.boundary;
    }

    public long getCount() {
        return this.count;
    }
}

