/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.core.formatMapper.shapefileParser.fieldname;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.CombineFileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.CombineFileSplit;
import org.apache.sedona.core.formatMapper.shapefileParser.fieldname.FieldnameRecordReader;

public class FieldnameInputFormat
extends CombineFileInputFormat<Long, String> {
    public RecordReader<Long, String> createRecordReader(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException {
        return new FieldnameRecordReader();
    }

    protected boolean isSplitable(JobContext context, Path file) {
        return false;
    }

    public List<InputSplit> getSplits(JobContext job) throws IOException {
        CombineFileSplit combineSplit = (CombineFileSplit)super.getSplits(job).get(0);
        Path[] paths = combineSplit.getPaths();
        ArrayList<Integer> shpIds = new ArrayList<Integer>();
        for (int i = 0; i < paths.length; ++i) {
            if (!FilenameUtils.getExtension((String)paths[i].toString()).equalsIgnoreCase("dbf")) continue;
            shpIds.add(i);
        }
        Path[] shpPaths = new Path[shpIds.size()];
        long[] shpStarts = new long[shpIds.size()];
        long[] shpLengths = new long[shpIds.size()];
        for (int i = 0; i < shpIds.size(); ++i) {
            int id = (Integer)shpIds.get(i);
            shpPaths[i] = combineSplit.getPath(id);
            shpStarts[i] = combineSplit.getOffset(id);
            shpLengths[i] = combineSplit.getLength(id);
        }
        CombineFileSplit shpSplit = new CombineFileSplit(shpPaths, shpStarts, shpLengths, combineSplit.getLocations());
        ArrayList<InputSplit> shpSplits = new ArrayList<InputSplit>();
        shpSplits.add((InputSplit)shpSplit);
        return shpSplits;
    }
}

