/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.common.geometrySerde;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.sedona.common.geometrySerde.CoordinateType;
import org.apache.sedona.common.geometrySerde.GeometryBuffer;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateXY;
import org.locationtech.jts.geom.CoordinateXYM;
import org.locationtech.jts.geom.CoordinateXYZM;
import org.locationtech.jts.geom.impl.CoordinateArraySequence;

class ByteBufferGeometryBuffer
implements GeometryBuffer {
    private CoordinateType coordinateType = CoordinateType.XY;
    private final ByteBuffer byteBuffer;
    private int markOffset = 0;

    public ByteBufferGeometryBuffer(int bufferSize) {
        this.byteBuffer = ByteBuffer.allocate(bufferSize);
        this.byteBuffer.order(ByteOrder.nativeOrder());
    }

    public ByteBufferGeometryBuffer(byte[] bytes) {
        this.byteBuffer = ByteBuffer.wrap(bytes).order(ByteOrder.nativeOrder());
    }

    public ByteBufferGeometryBuffer(ByteBuffer byteBuffer) {
        this.byteBuffer = byteBuffer.order(ByteOrder.nativeOrder());
    }

    @Override
    public CoordinateType getCoordinateType() {
        return this.coordinateType;
    }

    @Override
    public void setCoordinateType(CoordinateType coordinateType) {
        this.coordinateType = coordinateType;
    }

    @Override
    public int getLength() {
        return this.byteBuffer.capacity();
    }

    @Override
    public void mark(int offset) {
        this.markOffset = offset;
    }

    @Override
    public int getMark() {
        return this.markOffset;
    }

    @Override
    public void putByte(int offset, byte value) {
        this.byteBuffer.put(offset, value);
    }

    @Override
    public byte getByte(int offset) {
        return this.byteBuffer.get(offset);
    }

    @Override
    public void putBytes(int offset, byte[] bytes) {
        this.byteBuffer.position(offset);
        this.byteBuffer.put(bytes, 0, bytes.length);
    }

    @Override
    public void getBytes(byte[] bytes, int offset, int length) {
        this.byteBuffer.position(offset);
        this.byteBuffer.get(bytes, 0, length);
    }

    @Override
    public void putInt(int offset, int value) {
        this.byteBuffer.putInt(offset, value);
    }

    @Override
    public int getInt(int offset) {
        return this.byteBuffer.getInt(offset);
    }

    @Override
    public void putCoordinate(int offset, Coordinate coordinate) {
        this.byteBuffer.putDouble(offset, coordinate.x);
        this.byteBuffer.putDouble(offset + 8, coordinate.y);
        offset += 16;
        if (this.coordinateType.hasZ) {
            this.byteBuffer.putDouble(offset, coordinate.getZ());
            offset += 8;
        }
        if (this.coordinateType.hasM) {
            this.byteBuffer.putDouble(offset, coordinate.getM());
        }
    }

    @Override
    public CoordinateSequence getCoordinate(int offset) {
        double x = this.byteBuffer.getDouble(offset);
        double y = this.byteBuffer.getDouble(offset + 8);
        Coordinate[] coordinates = new Coordinate[1];
        switch (this.coordinateType) {
            case XY: {
                coordinates[0] = new CoordinateXY(x, y);
                return new CoordinateArraySequence(coordinates, 2, 0);
            }
            case XYZ: {
                double z = this.byteBuffer.getDouble(offset + 16);
                coordinates[0] = new Coordinate(x, y, z);
                return new CoordinateArraySequence(coordinates, 3, 0);
            }
            case XYM: {
                double m = this.byteBuffer.getDouble(offset + 16);
                coordinates[0] = new CoordinateXYM(x, y, m);
                return new CoordinateArraySequence(coordinates, 3, 1);
            }
            case XYZM: {
                double z = this.byteBuffer.getDouble(offset + 16);
                double m = this.byteBuffer.getDouble(offset + 24);
                coordinates[0] = new CoordinateXYZM(x, y, z, m);
                return new CoordinateArraySequence(coordinates, 4, 1);
            }
        }
        throw new IllegalStateException("coordinateType was not configured properly");
    }

    @Override
    public void putCoordinates(int offset, CoordinateSequence coordinates) {
        int numCoordinates = coordinates.size();
        switch (this.coordinateType) {
            case XY: {
                for (int k = 0; k < numCoordinates; ++k) {
                    Coordinate coord = coordinates.getCoordinate(k);
                    this.byteBuffer.putDouble(offset, coord.x);
                    this.byteBuffer.putDouble(offset + 8, coord.y);
                    offset += 16;
                }
                break;
            }
            case XYZ: {
                for (int k = 0; k < numCoordinates; ++k) {
                    Coordinate coord = coordinates.getCoordinate(k);
                    this.byteBuffer.putDouble(offset, coord.x);
                    this.byteBuffer.putDouble(offset + 8, coord.y);
                    this.byteBuffer.putDouble(offset + 16, coord.getZ());
                    offset += 24;
                }
                break;
            }
            case XYM: {
                for (int k = 0; k < numCoordinates; ++k) {
                    Coordinate coord = coordinates.getCoordinate(k);
                    this.byteBuffer.putDouble(offset, coord.x);
                    this.byteBuffer.putDouble(offset + 8, coord.y);
                    this.byteBuffer.putDouble(offset + 16, coord.getM());
                    offset += 24;
                }
                break;
            }
            case XYZM: {
                for (int k = 0; k < numCoordinates; ++k) {
                    Coordinate coord = coordinates.getCoordinate(k);
                    this.byteBuffer.putDouble(offset, coord.x);
                    this.byteBuffer.putDouble(offset + 8, coord.y);
                    this.byteBuffer.putDouble(offset + 16, coord.getZ());
                    this.byteBuffer.putDouble(offset + 24, coord.getM());
                    offset += 32;
                }
                break;
            }
            default: {
                throw new IllegalStateException("coordinateType was not configured properly");
            }
        }
    }

    @Override
    public CoordinateSequence getCoordinates(int offset, int numCoordinates) {
        Coordinate[] coordinates = new Coordinate[numCoordinates];
        int dimension = 2;
        int measures = 0;
        switch (this.coordinateType) {
            case XY: {
                for (int k = 0; k < numCoordinates; ++k) {
                    double x = this.byteBuffer.getDouble(offset);
                    double y = this.byteBuffer.getDouble(offset + 8);
                    coordinates[k] = new CoordinateXY(x, y);
                    offset += 16;
                }
                break;
            }
            case XYZ: {
                dimension = 3;
                for (int k = 0; k < numCoordinates; ++k) {
                    double x = this.byteBuffer.getDouble(offset);
                    double y = this.byteBuffer.getDouble(offset + 8);
                    double z = this.byteBuffer.getDouble(offset + 16);
                    coordinates[k] = new Coordinate(x, y, z);
                    offset += 24;
                }
                break;
            }
            case XYM: {
                dimension = 3;
                measures = 1;
                for (int k = 0; k < numCoordinates; ++k) {
                    double x = this.byteBuffer.getDouble(offset);
                    double y = this.byteBuffer.getDouble(offset + 8);
                    double m = this.byteBuffer.getDouble(offset + 16);
                    coordinates[k] = new CoordinateXYM(x, y, m);
                    offset += 24;
                }
                break;
            }
            case XYZM: {
                dimension = 4;
                measures = 1;
                for (int k = 0; k < numCoordinates; ++k) {
                    double x = this.byteBuffer.getDouble(offset);
                    double y = this.byteBuffer.getDouble(offset + 8);
                    double z = this.byteBuffer.getDouble(offset + 16);
                    double m = this.byteBuffer.getDouble(offset + 24);
                    coordinates[k] = new CoordinateXYZM(x, y, z, m);
                    offset += 32;
                }
                break;
            }
            default: {
                throw new IllegalStateException("coordinateType was not configured properly");
            }
        }
        return new CoordinateArraySequence(coordinates, dimension, measures);
    }

    @Override
    public GeometryBuffer slice(int offset) {
        this.byteBuffer.position(offset);
        return new ByteBufferGeometryBuffer(this.byteBuffer.slice());
    }

    @Override
    public byte[] toByteArray() {
        if (this.byteBuffer.arrayOffset() == 0) {
            return this.byteBuffer.array();
        }
        byte[] bytes = new byte[this.byteBuffer.capacity()];
        this.byteBuffer.get(bytes);
        return bytes;
    }
}

