/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.core.joinJudgement;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.sedona.core.monitoring.Metric;
import org.apache.sedona.core.spatialOperator.SpatialPredicate;
import org.apache.sedona.core.spatialOperator.SpatialPredicateEvaluators;
import org.apache.spark.TaskContext;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.index.SpatialIndex;

abstract class JudgementBase<T extends Geometry, U extends Geometry>
implements Serializable {
    private static final Logger log = LogManager.getLogger(JudgementBase.class);
    private final SpatialPredicate spatialPredicate;
    private transient SpatialPredicateEvaluators.SpatialPredicateEvaluator evaluator;
    protected final Metric buildCount;
    protected final Metric streamCount;
    protected final Metric resultCount;
    protected final Metric candidateCount;
    private int shapeCnt;
    private List<Pair<U, T>> batch = null;
    private int nextIndex = 0;

    protected JudgementBase(SpatialPredicate spatialPredicate, Metric buildCount, Metric streamCount, Metric resultCount, Metric candidateCount) {
        this.spatialPredicate = spatialPredicate;
        this.buildCount = buildCount;
        this.streamCount = streamCount;
        this.resultCount = resultCount;
        this.candidateCount = candidateCount;
        this.shapeCnt = 0;
    }

    protected void initPartition() {
        this.evaluator = SpatialPredicateEvaluators.create(this.spatialPredicate);
    }

    private boolean match(Geometry left, Geometry right) {
        return this.evaluator.eval(left, right);
    }

    protected boolean hasNextBase(SpatialIndex spatialIndex, Iterator<? extends Geometry> streamShapes, boolean buildLeft) {
        if (this.batch != null) {
            return true;
        }
        return this.populateNextBatch(spatialIndex, streamShapes, buildLeft);
    }

    protected boolean hasNextBase(List<? extends Geometry> buildShapes, Iterator<? extends Geometry> streamShapes) {
        if (this.batch != null) {
            return true;
        }
        return this.populateNextBatch(buildShapes, streamShapes);
    }

    protected Pair<U, T> nextBase(SpatialIndex spatialIndex, Iterator<? extends Geometry> streamShapes, boolean buildLeft) {
        if (this.batch == null) {
            this.populateNextBatch(spatialIndex, streamShapes, buildLeft);
        }
        if (this.batch != null) {
            Pair<U, T> result = this.batch.get(this.nextIndex);
            ++this.nextIndex;
            if (this.nextIndex >= this.batch.size()) {
                this.populateNextBatch(spatialIndex, streamShapes, buildLeft);
                this.nextIndex = 0;
            }
            return result;
        }
        throw new NoSuchElementException();
    }

    protected Pair<U, T> nextBase(List<? extends Geometry> buildShapes, Iterator<? extends Geometry> streamShapes) {
        if (this.batch == null) {
            this.populateNextBatch(buildShapes, streamShapes);
        }
        if (this.batch != null) {
            Pair<U, T> result = this.batch.get(this.nextIndex);
            ++this.nextIndex;
            if (this.nextIndex >= this.batch.size()) {
                this.populateNextBatch(buildShapes, streamShapes);
                this.nextIndex = 0;
            }
            return result;
        }
        throw new NoSuchElementException();
    }

    private boolean populateNextBatch(SpatialIndex spatialIndex, Iterator<? extends Geometry> streamShapes, boolean buildLeft) {
        if (!streamShapes.hasNext()) {
            if (this.batch != null) {
                this.batch = null;
            }
            return false;
        }
        this.batch = new ArrayList<Pair<U, T>>();
        while (streamShapes.hasNext()) {
            ++this.shapeCnt;
            this.streamCount.add(1L);
            Geometry streamShape = streamShapes.next();
            List candidates = spatialIndex.query(streamShape.getEnvelopeInternal());
            for (Object candidate : candidates) {
                this.candidateCount.add(1L);
                Geometry buildShape = (Geometry)candidate;
                if (buildLeft) {
                    if (!this.match(buildShape, streamShape)) continue;
                    this.batch.add(Pair.of((Object)buildShape, (Object)streamShape));
                    this.resultCount.add(1L);
                    continue;
                }
                if (!this.match(streamShape, buildShape)) continue;
                this.batch.add(Pair.of((Object)streamShape, (Object)buildShape));
                this.resultCount.add(1L);
            }
            this.logMilestone(this.shapeCnt, 100000L, "Streaming shapes");
            if (this.batch.isEmpty()) continue;
            return true;
        }
        this.batch = null;
        return false;
    }

    private boolean populateNextBatch(List<? extends Geometry> buildShapes, Iterator<? extends Geometry> streamShapes) {
        if (!streamShapes.hasNext()) {
            if (this.batch != null) {
                this.batch = null;
            }
            return false;
        }
        this.batch = new ArrayList<Pair<U, T>>();
        while (streamShapes.hasNext()) {
            ++this.shapeCnt;
            this.streamCount.add(1L);
            Geometry streamShape = streamShapes.next();
            for (Geometry geometry : buildShapes) {
                this.candidateCount.add(1L);
                Geometry buildShape = geometry;
                if (!this.match(streamShape, buildShape)) continue;
                this.batch.add(Pair.of((Object)streamShape, (Object)buildShape));
                this.resultCount.add(1L);
            }
            this.logMilestone(this.shapeCnt, 100000L, "Streaming shapes");
            if (this.batch.isEmpty()) continue;
            return true;
        }
        this.batch = null;
        return false;
    }

    protected void log(String message, Object ... params) {
        if (Level.INFO.isGreaterOrEqual((Priority)log.getEffectiveLevel())) {
            int partitionId = TaskContext.getPartitionId();
            long threadId = Thread.currentThread().getId();
            log.info((Object)("[" + threadId + ", PID=" + partitionId + "] " + String.format(message, params)));
        }
    }

    private void logMilestone(long cnt, long threshold, String name) {
        if (cnt > 1L && cnt % threshold == 1L) {
            this.log("[%s] Reached a milestone: %d", name, cnt);
        }
    }
}

