/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.common.raster;

import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.media.jai.RasterFactory;
import org.geotools.coverage.CoverageFactoryFinder;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.gce.arcgrid.ArcGridReader;
import org.geotools.gce.geotiff.GeoTiffReader;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultEngineeringCRS;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.geometry.BoundingBox;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;

public class RasterConstructors {
    public static GridCoverage2D fromArcInfoAsciiGrid(byte[] bytes) throws IOException {
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);){
            ArcGridReader reader = new ArcGridReader((Object)inputStream);
            GridCoverage2D gridCoverage2D = reader.read(null);
            return gridCoverage2D;
        }
    }

    public static GridCoverage2D fromGeoTiff(byte[] bytes) throws IOException {
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);){
            GeoTiffReader geoTiffReader = new GeoTiffReader((Object)inputStream);
            GridCoverage2D gridCoverage2D = geoTiffReader.read(null);
            return gridCoverage2D;
        }
    }

    public static GridCoverage2D makeEmptyRaster(int numBand, int widthInPixel, int heightInPixel, double upperLeftX, double upperLeftY, double pixelSize) throws FactoryException {
        return RasterConstructors.makeEmptyRaster(numBand, widthInPixel, heightInPixel, upperLeftX, upperLeftY, pixelSize, pixelSize, 0.0, 0.0, 0);
    }

    public static GridCoverage2D makeEmptyRaster(int numBand, int widthInPixel, int heightInPixel, double upperLeftX, double upperLeftY, double scaleX, double scaleY, double skewX, double skewY, int srid) throws FactoryException {
        Object crs = srid == 0 ? DefaultEngineeringCRS.GENERIC_2D : CRS.decode((String)("EPSG:" + srid));
        double actualScaleY = scaleY;
        if (scaleY == 2.147483647E9) {
            actualScaleY = scaleX;
        }
        System.out.println("makeEmptyRaster: " + numBand + ", " + widthInPixel + ", " + heightInPixel + ", " + upperLeftX + ", " + upperLeftY + ", " + scaleX + ", " + actualScaleY + ", " + skewX + ", " + skewY + ", " + srid);
        WritableRaster raster = RasterFactory.createBandedRaster((int)5, (int)widthInPixel, (int)heightInPixel, (int)numBand, null);
        AffineTransform2D transform = new AffineTransform2D(scaleX, skewY, skewX, -actualScaleY, upperLeftX + scaleX / 2.0, upperLeftY - actualScaleY / 2.0);
        GridGeometry2D gridGeometry = new GridGeometry2D((GridEnvelope)new GridEnvelope2D(0, 0, widthInPixel, heightInPixel), (MathTransform)transform, (CoordinateReferenceSystem)crs);
        ReferencedEnvelope referencedEnvelope = new ReferencedEnvelope((BoundingBox)gridGeometry.getEnvelope2D());
        GridCoverageFactory gridCoverageFactory = CoverageFactoryFinder.getGridCoverageFactory(null);
        return gridCoverageFactory.create((CharSequence)"genericCoverage", raster, (Envelope)referencedEnvelope);
    }
}

