/*
 * Decompiled with CFR 0.152.
 */
package thredds.client.catalog.tools;

import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.client.catalog.Dataset;
import thredds.client.catalog.Documentation;
import thredds.client.catalog.ThreddsMetadata;
import thredds.client.catalog.builder.DatasetBuilder;
import ucar.nc2.Attribute;
import ucar.nc2.constants.CF;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.units.DateRange;
import ucar.nc2.units.DateType;
import ucar.nc2.units.TimeDuration;

public class ThreddsMetadataAcdd {
    private static Logger log = LoggerFactory.getLogger(ThreddsMetadataAcdd.class);
    private Map<String, Attribute> ncfile;
    private Dataset ds;
    private ThreddsMetadata tmi;

    public ThreddsMetadataAcdd(Map<String, Attribute> ncfile, DatasetBuilder dsb) {
        this.ncfile = ncfile;
        this.ds = dsb.copyDataset(null);
        this.tmi = dsb.getInheritableMetadata();
    }

    public void extract() {
        Attribute att;
        this.extractTimeCoverage();
        if (this.ds.getGeospatialCoverage() == null) {
            this.tmi.set("GeospatialCoverage", this.extractGeospatialCoverage());
        }
        if ((att = this.ncfile.get("keywords")) != null) {
            String keywordList = att.getStringValue();
            Attribute att2 = this.ncfile.get("keywords_vocabulary");
            String keywords_vocabulary = att2 == null ? null : att2.getStringValue();
            this.addKeywords(keywordList, keywords_vocabulary);
        }
        if (this.ds.getAuthority() == null && (att = this.ncfile.get("naming_authority")) != null) {
            this.tmi.set("Authority", att.getStringValue());
        }
        if (this.ds.getDataFormatName() == null && (att = this.ncfile.get("cdm_data_type")) != null && att.isString()) {
            CF.FeatureType cf;
            String val = att.getStringValue();
            FeatureType ft = FeatureType.getType(val);
            if (ft == null && (cf = CF.FeatureType.getFeatureType(val)) != null) {
                ft = CF.FeatureType.convert(cf);
            }
            if (ft != null) {
                this.tmi.set("FeatureType", ft.name());
            } else {
                this.tmi.set("FeatureType", val);
            }
        }
        this.addDocumentation("title");
        this.addDocumentation("summary");
        this.addDocumentation("history");
        this.addDocumentation("comment");
        this.addDocumentation("processing_level");
        this.addDocumentation("acknowledgement", "funding");
        this.addDocumentation("license", "rights");
        this.addDate("date_created");
        this.addDate("date_modified");
        this.addSource(true, "creator_name", "creator_url", "creator_email");
        this.addSource(false, "publisher_name", "publisher_url", "publisher_email");
    }

    public void extractTimeCoverage() {
        Attribute startTimeAtt = this.ncfile.get("time_coverage_start");
        Attribute endTimeAtt = this.ncfile.get("time_coverage_end");
        Attribute durationAtt = this.ncfile.get("time_coverage_duration");
        Attribute resAtt = this.ncfile.get("time_coverage_resolution");
        if (startTimeAtt == null && endTimeAtt == null && durationAtt == null) {
            return;
        }
        String dateValue = null;
        DateType start = null;
        if (startTimeAtt != null) {
            try {
                dateValue = startTimeAtt.getStringValue();
                start = new DateType(dateValue, null, null);
            }
            catch (Exception e) {
                log.warn("MetadataExtractorAcdd Cant Parse start date '{}' for {} message= {}", new Object[]{dateValue, this.ds.getName(), e.getMessage()});
            }
        }
        DateType end = null;
        if (endTimeAtt != null) {
            try {
                dateValue = endTimeAtt.getStringValue();
                end = new DateType(dateValue, null, null);
            }
            catch (Exception e) {
                log.warn("MetadataExtractorAcdd Cant Parse end date '{}' for {} message= {}", new Object[]{dateValue, this.ds.getName(), e.getMessage()});
            }
        }
        TimeDuration duration = null;
        if (durationAtt != null) {
            try {
                dateValue = durationAtt.getStringValue();
                duration = new TimeDuration(dateValue);
            }
            catch (Exception e) {
                log.warn("MetadataExtractorAcdd Cant Parse duration '{}' for {} message= {}", new Object[]{dateValue, this.ds.getName(), e.getMessage()});
            }
        }
        TimeDuration resolution = null;
        if (resAtt != null) {
            try {
                dateValue = resAtt.getStringValue();
                resolution = new TimeDuration(dateValue);
            }
            catch (Exception e) {
                log.warn("MetadataExtractorAcdd Cant Parse resolution '{}' for {} message= {}", new Object[]{dateValue, this.ds.getName(), e.getMessage()});
            }
        }
        try {
            DateRange tc = new DateRange(start, end, duration, resolution);
            this.tmi.set("TimeCoverage", tc);
        }
        catch (Exception e) {
            log.warn("MetadataExtractorAcdd Cant Calculate DateRange for {} message= {}", (Object)this.ds.getName(), (Object)e.getMessage());
        }
    }

    public ThreddsMetadata.GeospatialCoverage extractGeospatialCoverage() {
        ThreddsMetadata.GeospatialRange latRange = this.makeRange(false, "geospatial_lat_min", "geospatial_lat_max", "geospatial_lat_resolution", "geospatial_lat_units");
        if (latRange == null) {
            return null;
        }
        ThreddsMetadata.GeospatialRange lonRange = this.makeRange(true, "geospatial_lon_min", "geospatial_lon_max", "geospatial_lon_resolution", "geospatial_lon_units");
        if (lonRange == null) {
            return null;
        }
        ThreddsMetadata.GeospatialRange altRange = this.makeRange(false, "geospatial_vertical_min", "geospatial_vertical_max", "geospatial_vertical_resolution", "geospatial_vertical_units");
        Attribute zposAtt = this.ncfile.get("geospatial_vertical_positive");
        String zIsPositive = zposAtt == null ? null : zposAtt.getStringValue();
        return new ThreddsMetadata.GeospatialCoverage(lonRange, latRange, altRange, null, zIsPositive);
    }

    private ThreddsMetadata.GeospatialRange makeRange(boolean isLon, String minName, String maxName, String resName, String unitsName) {
        Attribute unitAtt;
        Number result;
        Attribute minAtt = this.ncfile.get(minName);
        Attribute maxAtt = this.ncfile.get(maxName);
        if (minAtt == null || maxAtt == null) {
            return null;
        }
        Number minN = minAtt.getNumericValue();
        Number maxN = maxAtt.getNumericValue();
        if (minN == null || maxN == null) {
            return null;
        }
        double min2 = minN.doubleValue();
        double max = maxN.doubleValue();
        double size = max - min2;
        if (isLon && max < min2) {
            size += 360.0;
        }
        double res = Double.NaN;
        Attribute resAtt = this.ncfile.get(resName);
        if (resAtt != null && (result = resAtt.getNumericValue()) != null) {
            res = result.doubleValue();
        }
        String units = (unitAtt = this.ncfile.get(unitsName)) == null ? null : unitAtt.getStringValue();
        return new ThreddsMetadata.GeospatialRange(min2, size, res, units);
    }

    private void addDocumentation(String docType) {
        Attribute att = this.ncfile.get(docType);
        if (att != null) {
            String docValue = att.getStringValue();
            String dsValue = this.ds.getDocumentation(docType);
            if (dsValue == null || !dsValue.equals(docValue)) {
                this.tmi.addToList("Documentation", new Documentation(null, null, null, docType, docValue));
            }
        }
    }

    private void addDocumentation(String attName, String docType) {
        Attribute att = this.ncfile.get(attName);
        if (att != null) {
            String docValue = att.getStringValue();
            String dsValue = this.ds.getDocumentation(docType);
            if (dsValue == null || !dsValue.equals(docValue)) {
                this.tmi.addToList("Documentation", new Documentation(null, null, null, docType, docValue));
            }
        }
    }

    private void addKeywords(String keywordList, String vocabulary) {
        String[] keywords;
        for (String kw : keywords = keywordList.split(",")) {
            this.tmi.addToList("Keywords", new ThreddsMetadata.Vocab(kw, vocabulary));
        }
    }

    private void addDate(String dateType) {
        Attribute att = this.ncfile.get(dateType);
        if (att != null) {
            String dateValue = att.getStringValue();
            try {
                this.tmi.addToList("Dates", new DateType(dateValue, null, dateType));
            }
            catch (Exception e) {
                log.warn("MetadataExtractorAcdd Cant Parse {} date '{}' for {} message= {}", new Object[]{dateType, dateValue, this.ds.getName(), e.getMessage()});
            }
        }
    }

    private void addSource(boolean isCreator, String sourceName, String urlName, String emailName) {
        Attribute att = this.ncfile.get(sourceName);
        if (att != null) {
            String sourceValue = att.getStringValue();
            Attribute urlAtt = this.ncfile.get(urlName);
            String url = urlAtt == null ? null : urlAtt.getStringValue();
            Attribute emailAtt = this.ncfile.get(emailName);
            String email = emailAtt == null ? null : emailAtt.getStringValue();
            ThreddsMetadata.Vocab name = new ThreddsMetadata.Vocab(sourceValue, null);
            ThreddsMetadata.Source src = new ThreddsMetadata.Source(name, url, email);
            if (isCreator) {
                this.tmi.addToList("Creators", src);
            } else {
                this.tmi.addToList("Publishers", src);
            }
        }
    }
}

