/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.jiffle.parser.node;

import it.geosolutions.jaiext.jiffle.parser.JiffleType;
import it.geosolutions.jaiext.jiffle.parser.node.Expression;
import it.geosolutions.jaiext.jiffle.parser.node.ImagePos;
import it.geosolutions.jaiext.jiffle.parser.node.SourceWriter;
import java.util.Objects;

public class GetSourceValue
extends Expression {
    private static String fmt = "readFromImage(%s,%s)";
    private final String varName;
    private final ImagePos pos;
    private String variableName;

    public GetSourceValue(String varName, ImagePos pos) {
        super(JiffleType.D);
        this.varName = varName;
        this.pos = pos;
    }

    @Override
    public JiffleType getType() {
        return JiffleType.D;
    }

    public String toString() {
        return String.format(fmt, this.varName, this.pos);
    }

    @Override
    public void write(SourceWriter w) {
        if (this.variableName != null) {
            w.append(this.variableName);
        } else if (w.isInternalBaseClass()) {
            w.append("s_").append(this.varName).append(".read(").append(this.pos).append(")");
        } else {
            w.append("readFromImage(\"").append(this.varName).append("\", ").append(this.pos).append(")");
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GetSourceValue that = (GetSourceValue)o;
        return Objects.equals(this.varName, that.varName) && Objects.equals(this.pos, that.pos);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.varName, this.pos);
    }

    public String getVarName() {
        return this.varName;
    }

    public ImagePos getPos() {
        return this.pos;
    }

    public void setVariableName(String variableName) {
        this.variableName = variableName;
    }
}

