/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.jiffle.parser.node;

import it.geosolutions.jaiext.jiffle.parser.JiffleType;
import it.geosolutions.jaiext.jiffle.parser.node.Expression;
import it.geosolutions.jaiext.jiffle.parser.node.SourceWriter;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ImageProperty
extends Expression {
    private final Property property;
    private final String varName;

    public ImageProperty(String varName, String property) {
        this(varName, ImageProperty.lookupProperty(property));
    }

    public static Property lookupProperty(String property) {
        Map<String, Property> properties = Arrays.stream(Property.values()).collect(Collectors.toMap(p -> p.getName(), p -> p));
        Property result = properties.get(property);
        if (result == null) {
            List keys = properties.keySet().stream().sorted().collect(Collectors.toList());
            throw new IllegalArgumentException("Could not find a property named '" + property + "', available values are: " + keys);
        }
        return result;
    }

    public ImageProperty(String varName, Property property) {
        super(property.getType());
        this.varName = varName;
        this.property = property;
    }

    @Override
    public void write(SourceWriter w) {
        w.append(this.toString());
    }

    public String toString() {
        return this.property.getRuntimeMethod() + "(\"" + this.varName + "\")";
    }

    public static enum Property {
        BANDS("bands", "getBands", JiffleType.D);

        private final JiffleType type;
        private final String name;
        private final String runtimeMethod;

        private Property(String name, String runtimeMethod, JiffleType type) {
            this.name = name;
            this.runtimeMethod = runtimeMethod;
            this.type = type;
        }

        public JiffleType getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public String getRuntimeMethod() {
            return this.runtimeMethod;
        }
    }
}

