/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.jiffle.parser.node;

import it.geosolutions.jaiext.jiffle.parser.DirectSources;
import it.geosolutions.jaiext.jiffle.parser.Errors;
import it.geosolutions.jaiext.jiffle.parser.JiffleType;
import it.geosolutions.jaiext.jiffle.parser.node.Expression;
import it.geosolutions.jaiext.jiffle.parser.node.NodeException;
import it.geosolutions.jaiext.jiffle.parser.node.SourceWriter;
import java.util.Arrays;

public class ConFunction
extends Expression {
    private final Expression[] args;

    public ConFunction(Expression ... args) throws NodeException {
        super(args[0].getType());
        if (args[0].getType() != JiffleType.D) {
            throw new NodeException(Errors.CON_CONDITION_MUST_BE_SCALAR);
        }
        if (args.length > 2) {
            for (int i = 2; i < args.length; ++i) {
                if (args[1].getType() == args[i].getType()) continue;
                throw new NodeException(Errors.CON_RESULTS_MUST_BE_SAME_TYPE);
            }
        }
        this.args = args;
    }

    public String toString() {
        String[] argStrs = new String[this.args.length];
        int i = 0;
        for (Expression arg : this.args) {
            argStrs[i++] = arg.toString();
        }
        return DirectSources.conCall(argStrs);
    }

    @Override
    public void write(SourceWriter w) {
        String[] argStrs = new String[this.args.length];
        int i = 0;
        for (Expression arg : this.args) {
            argStrs[i++] = w.writeToString(arg);
        }
        w.append(DirectSources.conCall(argStrs));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConFunction that = (ConFunction)o;
        return Arrays.equals(this.args, that.args);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.args);
    }

    public Expression[] getArgs() {
        return this.args;
    }
}

