/*
 * Decompiled with CFR 0.152.
 */
package ucar.ma2;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Formatter;
import ucar.ma2.Array;
import ucar.ma2.ArrayStructure;
import ucar.ma2.ArrayStructureW;
import ucar.ma2.DataType;
import ucar.ma2.IndexIterator;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataIterator;
import ucar.ma2.StructureMembers;
import ucar.nc2.util.Indent;

public class ArraySequence
extends ArrayStructure {
    protected StructureDataIterator iter;

    protected ArraySequence(StructureMembers sm, int[] shape) {
        super(sm, shape);
    }

    public ArraySequence(StructureMembers members, StructureDataIterator iter, int nelems) {
        super(members, new int[]{0});
        this.iter = iter;
        this.nelems = nelems;
    }

    @Override
    public Class getElementType() {
        return StructureDataIterator.class;
    }

    @Override
    public StructureDataIterator getStructureDataIterator() {
        this.iter = this.iter.reset();
        return this.iter;
    }

    public int getStructureDataCount() {
        return this.nelems;
    }

    @Override
    public long getSizeBytes() {
        return this.nelems * this.members.getStructureSize();
    }

    @Override
    protected StructureData makeStructureData(ArrayStructure as, int index) {
        throw new UnsupportedOperationException("Cannot subset a Sequence");
    }

    @Override
    public Array extractMemberArray(StructureMembers.Member proxym) throws IOException {
        Array result;
        if (proxym.getDataArray() != null) {
            return proxym.getDataArray();
        }
        DataType dataType = proxym.getDataType();
        boolean isScalar = proxym.getSize() == 1 || dataType == DataType.SEQUENCE;
        int[] mshape = proxym.getShape();
        int rrank = 1 + mshape.length;
        int[] rshape = new int[rrank];
        rshape[0] = this.nelems;
        System.arraycopy(mshape, 0, rshape, 1, mshape.length);
        if (this.nelems < 0) {
            return this.extractMemberArrayFromIteration(proxym, rshape);
        }
        if (dataType == DataType.STRUCTURE) {
            StructureMembers membersw = proxym.getStructureMembers().toBuilder(false).build();
            result = new ArrayStructureW(membersw, rshape);
        } else {
            result = Array.factory(dataType, rshape);
        }
        try (StructureDataIterator sdataIter = this.getStructureDataIterator();){
            IndexIterator resultIter = result.getIndexIterator();
            while (sdataIter.hasNext()) {
                Object[] data;
                StructureData sdata = sdataIter.next();
                StructureMembers.Member realm = sdata.getStructureMembers().findMember(proxym.getName());
                if (isScalar) {
                    if (dataType == DataType.DOUBLE) {
                        resultIter.setDoubleNext(sdata.getScalarDouble(realm));
                        continue;
                    }
                    if (dataType == DataType.FLOAT) {
                        resultIter.setFloatNext(sdata.getScalarFloat(realm));
                        continue;
                    }
                    if (dataType.getPrimitiveClassType() == Byte.TYPE) {
                        resultIter.setByteNext(sdata.getScalarByte(realm));
                        continue;
                    }
                    if (dataType.getPrimitiveClassType() == Short.TYPE) {
                        resultIter.setShortNext(sdata.getScalarShort(realm));
                        continue;
                    }
                    if (dataType.getPrimitiveClassType() == Integer.TYPE) {
                        resultIter.setIntNext(sdata.getScalarInt(realm));
                        continue;
                    }
                    if (dataType.getPrimitiveClassType() == Long.TYPE) {
                        resultIter.setLongNext(sdata.getScalarLong(realm));
                        continue;
                    }
                    if (dataType == DataType.CHAR) {
                        resultIter.setCharNext(sdata.getScalarChar(realm));
                        continue;
                    }
                    if (dataType == DataType.STRING) {
                        resultIter.setObjectNext(sdata.getScalarString(realm));
                        continue;
                    }
                    if (dataType == DataType.STRUCTURE) {
                        resultIter.setObjectNext(sdata.getScalarStructure(realm));
                        continue;
                    }
                    if (dataType != DataType.SEQUENCE) continue;
                    resultIter.setObjectNext(sdata.getArraySequence(realm));
                    continue;
                }
                if (dataType == DataType.DOUBLE) {
                    for (double aData : data = sdata.getJavaArrayDouble(realm)) {
                        resultIter.setDoubleNext(aData);
                    }
                    continue;
                }
                if (dataType == DataType.FLOAT) {
                    for (double aData : data = (Object[])sdata.getJavaArrayFloat(realm)) {
                        resultIter.setFloatNext((float)aData);
                    }
                    continue;
                }
                if (dataType.getPrimitiveClassType() == Byte.TYPE) {
                    for (double aData : data = (Object[])sdata.getJavaArrayByte(realm)) {
                        resultIter.setByteNext((byte)aData);
                    }
                    continue;
                }
                if (dataType.getPrimitiveClassType() == Short.TYPE) {
                    for (double aData : data = (Object[])sdata.getJavaArrayShort(realm)) {
                        resultIter.setShortNext((short)aData);
                    }
                    continue;
                }
                if (dataType.getPrimitiveClassType() == Integer.TYPE) {
                    for (double aData : data = (Object[])sdata.getJavaArrayInt(realm)) {
                        resultIter.setIntNext((int)aData);
                    }
                    continue;
                }
                if (dataType.getPrimitiveClassType() == Long.TYPE) {
                    for (double aData : data = (Object[])sdata.getJavaArrayLong(realm)) {
                        resultIter.setLongNext((long)aData);
                    }
                    continue;
                }
                if (dataType == DataType.CHAR) {
                    for (double aData : data = (Object[])sdata.getJavaArrayChar(realm)) {
                        resultIter.setCharNext((char)aData);
                    }
                    continue;
                }
                if (dataType == DataType.STRING) {
                    for (double aData : data = (Object[])sdata.getJavaArrayString(realm)) {
                        resultIter.setObjectNext(aData);
                    }
                    continue;
                }
                if (dataType != DataType.STRUCTURE) continue;
                ArrayStructure as = sdata.getArrayStructure(realm);
                StructureDataIterator innerIter = as.getStructureDataIterator();
                while (innerIter.hasNext()) {
                    resultIter.setObjectNext(innerIter.next());
                }
            }
        }
        return result;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private Array extractMemberArrayFromIteration(StructureMembers.Member proxym, int[] rshape) throws IOException {
        dataType = proxym.getDataType();
        dataArray /* !! */  = null;
        count = 0;
        initial = 1000;
        sdataIter = this.getStructureDataIterator();
        var8_8 = null;
        try {
            switch (1.$SwitchMap$ucar$ma2$DataType[dataType.ordinal()]) {
                case 1: {
                    result = new ArrayList<Object>(initial);
                    while (sdataIter.hasNext()) {
                        sdata = sdataIter.next();
                        realm = sdata.getStructureMembers().findMember(proxym.getName());
                        for (Object aData : data = (Object)sdata.getJavaArrayDouble(realm)) {
                            result.add((double)aData);
                        }
                        ++count;
                    }
                    da = new double[result.size()];
                    i = 0;
                    for (Double d : result) {
                        da[i++] = d;
                    }
                    dataArray /* !! */  = da;
                    ** break;
lbl27:
                    // 1 sources

                    break;
                }
                case 2: {
                    result = new ArrayList<E>(initial);
                    while (sdataIter.hasNext()) {
                        sdata = sdataIter.next();
                        realm = sdata.getStructureMembers().findMember(proxym.getName());
                        for (Object aData : data = (Object)sdata.getJavaArrayFloat(realm)) {
                            result.add(Float.valueOf((float)aData));
                        }
                        ++count;
                    }
                    da = new float[result.size()];
                    i = 0;
                    for (Object d : result) {
                        da[i++] = d.floatValue();
                    }
                    dataArray /* !! */  = da;
                    ** break;
lbl46:
                    // 1 sources

                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    result = new ArrayList<E>(initial);
                    while (sdataIter.hasNext()) {
                        sdata = sdataIter.next();
                        realm = sdata.getStructureMembers().findMember(proxym.getName());
                        for (Object aData : data = (Object)sdata.getJavaArrayByte(realm)) {
                            result.add((byte)aData);
                        }
                        ++count;
                    }
                    da = new byte[result.size()];
                    i = 0;
                    for (Object d : result) {
                        da[i++] = d.byteValue();
                    }
                    dataArray /* !! */  = da;
                    ** break;
lbl65:
                    // 1 sources

                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    result = new ArrayList<E>(initial);
                    while (sdataIter.hasNext()) {
                        sdata = sdataIter.next();
                        realm = sdata.getStructureMembers().findMember(proxym.getName());
                        for (Object aData : data = (Object)sdata.getJavaArrayShort(realm)) {
                            result.add((short)aData);
                        }
                        ++count;
                    }
                    da = new short[result.size()];
                    i = 0;
                    for (Object d : result) {
                        da[i++] = d.shortValue();
                    }
                    dataArray /* !! */  = da;
                    ** break;
lbl84:
                    // 1 sources

                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    result = new ArrayList<E>(initial);
                    while (sdataIter.hasNext()) {
                        sdata = sdataIter.next();
                        realm = sdata.getStructureMembers().findMember(proxym.getName());
                        for (Object aData : data = (Object)sdata.getJavaArrayInt(realm)) {
                            result.add((int)aData);
                        }
                        ++count;
                    }
                    da = new int[result.size()];
                    i = 0;
                    for (Object d : result) {
                        da[i++] = d.intValue();
                    }
                    dataArray /* !! */  = da;
                    ** break;
lbl103:
                    // 1 sources

                    break;
                }
                case 12: 
                case 13: {
                    result = new ArrayList<E>(initial);
                    while (sdataIter.hasNext()) {
                        sdata = sdataIter.next();
                        realm = sdata.getStructureMembers().findMember(proxym.getName());
                        for (Object aData : data = (Object)sdata.getJavaArrayLong(realm)) {
                            result.add((long)aData);
                        }
                        ++count;
                    }
                    da = new long[result.size()];
                    i = 0;
                    for (Object d : result) {
                        da[i++] = d.longValue();
                    }
                    dataArray /* !! */  = da;
                    ** break;
lbl122:
                    // 1 sources

                    break;
                }
                case 14: {
                    result = new ArrayList<E>(initial);
                    while (sdataIter.hasNext()) {
                        sdata = sdataIter.next();
                        realm = sdata.getStructureMembers().findMember(proxym.getName());
                        for (Object aData : data = (Object)sdata.getJavaArrayChar(realm)) {
                            result.add(Character.valueOf((char)aData));
                        }
                        ++count;
                    }
                    da = new char[result.size()];
                    i = 0;
                    for (Object d : result) {
                        da[i++] = d.charValue();
                    }
                    dataArray /* !! */  = da;
                    ** break;
lbl141:
                    // 1 sources

                    break;
                }
                case 15: {
                    result = new ArrayList<E>(initial);
                    while (sdataIter.hasNext()) {
                        sdata = sdataIter.next();
                        realm = sdata.getStructureMembers().findMember(proxym.getName());
                        data = sdata.getJavaArrayString(realm);
                        result.addAll(Arrays.asList(data));
                        ++count;
                    }
                    da = new String[result.size()];
                    i = 0;
                    for (String d : result) {
                        da[i++] = d;
                    }
                    dataArray /* !! */  = (double[])da;
                    ** break;
lbl159:
                    // 1 sources

                    break;
                }
                case 16: {
                    result = new ArrayList<StructureData>(initial);
                    while (sdataIter.hasNext()) {
                        sdata = sdataIter.next();
                        realm = sdata.getStructureMembers().findMember(proxym.getName());
                        as = sdata.getArrayStructure(realm);
                        innerIter = as.getStructureDataIterator();
                        while (innerIter.hasNext()) {
                            result.add(innerIter.next());
                        }
                        ++count;
                    }
                    rshape[0] = count;
                    membersw = proxym.getStructureMembers().toBuilder(false).build();
                    var11_38 = new ArrayStructureW(membersw, rshape, result.toArray(new StructureData[0]));
                    return var11_38;
                }
                ** default:
lbl178:
                // 1 sources

                break;
            }
        }
        catch (Throwable var9_12) {
            var8_8 = var9_12;
            throw var9_12;
        }
        finally {
            if (sdataIter != null) {
                if (var8_8 != null) {
                    try {
                        sdataIter.close();
                    }
                    catch (Throwable var9_11) {
                        var8_8.addSuppressed(var9_11);
                    }
                } else {
                    sdataIter.close();
                }
            }
        }
        rshape[0] = count;
        return Array.factory(dataType, rshape, dataArray /* !! */ );
    }

    @Override
    public String toString() {
        return "seq n=" + this.nelems;
    }

    @Override
    public void showInternal(Formatter f, Indent indent) {
        super.showInternal(f, indent);
        f.format("%sStructureDataIterator Class=%s hash=0x%x%n", indent, this.iter.getClass().getName(), this.iter.hashCode());
        if (this.iter instanceof ArrayStructure.ArrayStructureIterator) {
            ArrayStructure.ArrayStructureIterator ii = (ArrayStructure.ArrayStructureIterator)this.iter;
            ii.getArrayStructure().showInternal(f, indent.incr());
            indent.decr();
        }
    }
}

