/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.common.utils;

import java.awt.image.Raster;
import java.awt.image.WritableRaster;

public class ImageUtils {
    private ImageUtils() {
    }

    public static void copyRasterWithPadding(Raster sourceRaster, int sourceBand, WritableRaster destRaster, int destBand, double padValue) {
        int x;
        int y;
        int destWidth = destRaster.getWidth();
        int destHeight = destRaster.getHeight();
        int destMinX = destRaster.getMinX();
        int destMinY = destRaster.getMinY();
        int sourceWidth = sourceRaster.getWidth();
        int sourceHeight = sourceRaster.getHeight();
        int sourceMinX = sourceRaster.getMinX();
        int sourceMinY = sourceRaster.getMinY();
        if (sourceWidth > destWidth || sourceHeight > destHeight) {
            throw new IllegalArgumentException("Source raster is larger than destination raster");
        }
        double[] samples = sourceRaster.getSamples(sourceMinX, sourceMinY, sourceWidth, sourceHeight, sourceBand, (double[])null);
        destRaster.setSamples(destMinX, destMinY, sourceWidth, sourceHeight, destBand, samples);
        for (y = destMinY; y < sourceHeight + destMinY; ++y) {
            for (x = sourceWidth + destMinX; x < destWidth + destMinX; ++x) {
                destRaster.setSample(x, y, destBand, padValue);
            }
        }
        for (y = sourceHeight + destMinY; y < destHeight + destMinY; ++y) {
            for (x = destMinX; x < destWidth + destMinX; ++x) {
                destRaster.setSample(x, y, destBand, padValue);
            }
        }
    }
}

