/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.core.formatMapper.shapefileParser.parseUtils.shp;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.sedona.core.formatMapper.shapefileParser.parseUtils.shp.MultiPointParser;
import org.apache.sedona.core.formatMapper.shapefileParser.parseUtils.shp.PointParser;
import org.apache.sedona.core.formatMapper.shapefileParser.parseUtils.shp.PolyLineParser;
import org.apache.sedona.core.formatMapper.shapefileParser.parseUtils.shp.PolygonParser;
import org.apache.sedona.core.formatMapper.shapefileParser.parseUtils.shp.ShapeParser;
import org.apache.sedona.core.formatMapper.shapefileParser.parseUtils.shp.TypeUnknownException;
import org.locationtech.jts.geom.GeometryFactory;

public enum ShapeType implements Serializable
{
    NULL(0, false),
    POINT(1, true),
    POLYLINE(3, true),
    POLYGON(5, true),
    MULTIPOINT(8, true),
    POINTZ(11, false),
    POLYLINEZ(13, false),
    POLYGONZ(15, false),
    MULTIPOINTZ(18, false),
    POINTM(21, false),
    POLYLINEM(23, false),
    POLYGONM(25, false),
    MULTIPOINTM(28, false),
    MULTIPATCH(31, false),
    UNDEFINED(-1, false);

    private final int id;
    private final boolean supported;
    private static final Map<Integer, ShapeType> lookup;

    private ShapeType(int id, boolean supported) {
        this.id = id;
        this.supported = supported;
    }

    public static ShapeType getType(int id) {
        ShapeType type = lookup.get(id);
        return type == null ? UNDEFINED : type;
    }

    public ShapeParser getParser(GeometryFactory geometryFactory) {
        switch (this) {
            case POINT: {
                return new PointParser(geometryFactory);
            }
            case POLYLINE: {
                return new PolyLineParser(geometryFactory);
            }
            case POLYGON: {
                return new PolygonParser(geometryFactory);
            }
            case MULTIPOINT: {
                return new MultiPointParser(geometryFactory);
            }
        }
        throw new TypeUnknownException(this.id);
    }

    public int getId() {
        return this.id;
    }

    public boolean isSupported() {
        return this.supported;
    }

    static {
        lookup = new HashMap<Integer, ShapeType>();
        for (ShapeType s2 : ShapeType.values()) {
            lookup.put(s2.id, s2);
        }
    }
}

