/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.sedona_sql.io.geojson;

import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.ExprUtils$;
import org.apache.spark.sql.catalyst.json.JSONOptions;
import org.apache.spark.sql.catalyst.json.JSONOptionsInRead;
import org.apache.spark.sql.catalyst.json.JacksonParser;
import org.apache.spark.sql.catalyst.util.CompressionCodecs$;
import org.apache.spark.sql.execution.datasources.CodecStreams$;
import org.apache.spark.sql.execution.datasources.OutputWriter;
import org.apache.spark.sql.execution.datasources.OutputWriterFactory;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.execution.datasources.TextBasedFileFormat;
import org.apache.spark.sql.execution.datasources.json.JsonDataSource;
import org.apache.spark.sql.execution.datasources.json.JsonDataSource$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.sedona_sql.UDT.GeometryUDT$;
import org.apache.spark.sql.sedona_sql.UDT.RasterUDT$;
import org.apache.spark.sql.sedona_sql.io.geojson.GeoJSONOutputWriter;
import org.apache.spark.sql.sedona_sql.io.geojson.GeoJSONUtils$;
import org.apache.spark.sql.sedona_sql.io.geojson.SparkCompatUtil$;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.NullType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.util.SerializableConfiguration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\re\u0001\u0002\u0007\u000e\u0001qAQa\u000b\u0001\u0005\u00021Bqa\f\u0001C\u0002\u0013\u0005\u0003\u0007\u0003\u0004?\u0001\u0001\u0006I!\r\u0005\u0006\u007f\u0001!\t\u0005\u0011\u0005\u00065\u0002!\te\u0017\u0005\u0006k\u0002!\tE\u001e\u0005\b\u0003\u001b\u0001A\u0011IA\b\u0011\u001d\tI\u0006\u0001C!\u00037Bq!!\u0018\u0001\t\u0003\ny\u0006C\u0004\u0002h\u0001!\t%!\u001b\t\u000f\u0005U\u0004\u0001\"\u0011\u0002x\t\tr)Z8K'>se)\u001b7f\r>\u0014X.\u0019;\u000b\u00059y\u0011aB4f_*\u001cxN\u001c\u0006\u0003!E\t!![8\u000b\u0005I\u0019\u0012AC:fI>t\u0017mX:rY*\u0011A#F\u0001\u0004gFd'B\u0001\f\u0018\u0003\u0015\u0019\b/\u0019:l\u0015\tA\u0012$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u00025\u0005\u0019qN]4\u0004\u0001M\u0019\u0001!H\u0013\u0011\u0005y\u0019S\"A\u0010\u000b\u0005\u0001\n\u0013a\u00033bi\u0006\u001cx.\u001e:dKNT!AI\n\u0002\u0013\u0015DXmY;uS>t\u0017B\u0001\u0013 \u0005M!V\r\u001f;CCN,GMR5mK\u001a{'/\\1u!\t1\u0013&D\u0001(\u0015\tA3#A\u0004t_V\u00148-Z:\n\u0005):#A\u0005#bi\u0006\u001cv.\u001e:dKJ+w-[:uKJ\fa\u0001P5oSRtD#A\u0017\u0011\u00059\u0002Q\"A\u0007\u0002\u0013MDwN\u001d;OC6,W#A\u0019\u0011\u0005IZdBA\u001a:!\t!t'D\u00016\u0015\t14$\u0001\u0004=e>|GO\u0010\u0006\u0002q\u0005)1oY1mC&\u0011!hN\u0001\u0007!J,G-\u001a4\n\u0005qj$AB*ue&twM\u0003\u0002;o\u0005Q1\u000f[8si:\u000bW.\u001a\u0011\u0002\u0017%\u001c8\u000b\u001d7ji\u0006\u0014G.\u001a\u000b\u0005\u0003\u0016[\u0005\u000b\u0005\u0002C\u00076\tq'\u0003\u0002Eo\t9!i\\8mK\u0006t\u0007\"\u0002$\u0005\u0001\u00049\u0015\u0001D:qCJ\\7+Z:tS>t\u0007C\u0001%J\u001b\u0005\u0019\u0012B\u0001&\u0014\u00051\u0019\u0006/\u0019:l'\u0016\u001c8/[8o\u0011\u0015aE\u00011\u0001N\u0003\u001dy\u0007\u000f^5p]N\u0004BA\r(2c%\u0011q*\u0010\u0002\u0004\u001b\u0006\u0004\b\"B)\u0005\u0001\u0004\u0011\u0016\u0001\u00029bi\"\u0004\"a\u0015-\u000e\u0003QS!!\u0016,\u0002\u0005\u0019\u001c(BA,\u0018\u0003\u0019A\u0017\rZ8pa&\u0011\u0011\f\u0016\u0002\u0005!\u0006$\b.A\u0006j]\u001a,'oU2iK6\fG\u0003\u0002/fM\u001e\u00042AQ/`\u0013\tqvG\u0001\u0004PaRLwN\u001c\t\u0003A\u000el\u0011!\u0019\u0006\u0003EN\tQ\u0001^=qKNL!\u0001Z1\u0003\u0015M#(/^2u)f\u0004X\rC\u0003G\u000b\u0001\u0007q\tC\u0003M\u000b\u0001\u0007Q\nC\u0003i\u000b\u0001\u0007\u0011.A\u0003gS2,7\u000fE\u0002k_Jt!a[7\u000f\u0005Qb\u0017\"\u0001\u001d\n\u00059<\u0014a\u00029bG.\fw-Z\u0005\u0003aF\u00141aU3r\u0015\tqw\u0007\u0005\u0002Tg&\u0011A\u000f\u0016\u0002\u000b\r&dWm\u0015;biV\u001c\u0018\u0001\u00049sKB\f'/Z,sSR,GcB<{w\u0006\u001d\u0011\u0011\u0002\t\u0003=aL!!_\u0010\u0003'=+H\u000f];u/JLG/\u001a:GC\u000e$xN]=\t\u000b\u00193\u0001\u0019A$\t\u000bq4\u0001\u0019A?\u0002\u0007)|'\rE\u0002\u007f\u0003\u0007i\u0011a \u0006\u0004\u0003\u00031\u0016!C7baJ,G-^2f\u0013\r\t)a \u0002\u0004\u0015>\u0014\u0007\"\u0002'\u0007\u0001\u0004i\u0005BBA\u0006\r\u0001\u0007q,\u0001\u0006eCR\f7k\u00195f[\u0006\f1BY;jY\u0012\u0014V-\u00193feR\u0001\u0012\u0011CA\u0018\u0003c\t\u0019$a\u000e\u0002<\u0005\u001d\u0013\u0011\n\t\b\u0005\u0006M\u0011qCA\u000f\u0013\r\t)b\u000e\u0002\n\rVt7\r^5p]F\u00022AHA\r\u0013\r\tYb\b\u0002\u0010!\u0006\u0014H/\u001b;j_:,GMR5mKB)!.a\b\u0002$%\u0019\u0011\u0011E9\u0003\u0011%#XM]1u_J\u0004B!!\n\u0002,5\u0011\u0011q\u0005\u0006\u0004\u0003S\u0019\u0012\u0001C2bi\u0006d\u0017p\u001d;\n\t\u00055\u0012q\u0005\u0002\f\u0013:$XM\u001d8bYJ{w\u000fC\u0003G\u000f\u0001\u0007q\t\u0003\u0004\u0002\f\u001d\u0001\ra\u0018\u0005\u0007\u0003k9\u0001\u0019A0\u0002\u001fA\f'\u000f^5uS>t7k\u00195f[\u0006Da!!\u000f\b\u0001\u0004y\u0016A\u0004:fcVL'/\u001a3TG\",W.\u0019\u0005\b\u0003{9\u0001\u0019AA \u0003\u001d1\u0017\u000e\u001c;feN\u0004BA[8\u0002BA\u0019a%a\u0011\n\u0007\u0005\u0015sE\u0001\u0004GS2$XM\u001d\u0005\u0006\u0019\u001e\u0001\r!\u0014\u0005\b\u0003\u0017:\u0001\u0019AA'\u0003)A\u0017\rZ8pa\u000e{gN\u001a\t\u0005\u0003\u001f\n)&\u0004\u0002\u0002R)\u0019\u00111\u000b,\u0002\t\r|gNZ\u0005\u0005\u0003/\n\tFA\u0007D_:4\u0017nZ;sCRLwN\\\u0001\ti>\u001cFO]5oOR\t\u0011'\u0001\u0005iCND7i\u001c3f)\t\t\t\u0007E\u0002C\u0003GJ1!!\u001a8\u0005\rIe\u000e^\u0001\u0007KF,\u0018\r\\:\u0015\u0007\u0005\u000bY\u0007C\u0004\u0002n)\u0001\r!a\u001c\u0002\u000b=$\b.\u001a:\u0011\u0007\t\u000b\t(C\u0002\u0002t]\u00121!\u00118z\u0003=\u0019X\u000f\u001d9peR$\u0015\r^1UsB,GcA!\u0002z!9\u00111P\u0006A\u0002\u0005u\u0014\u0001\u00033bi\u0006$\u0016\u0010]3\u0011\u0007\u0001\fy(C\u0002\u0002\u0002\u0006\u0014\u0001\u0002R1uCRK\b/\u001a")
public class GeoJSONFileFormat
extends TextBasedFileFormat
implements DataSourceRegister {
    private final String shortName;

    public String shortName() {
        return this.shortName;
    }

    public boolean isSplitable(SparkSession sparkSession, Map<String, String> options, Path path) {
        JSONOptionsInRead parsedOptions = new JSONOptionsInRead(options, sparkSession.sessionState().conf().sessionLocalTimeZone(), sparkSession.sessionState().conf().columnNameOfCorruptRecord());
        JsonDataSource jsonDataSource = JsonDataSource$.MODULE$.apply((JSONOptions)parsedOptions);
        return jsonDataSource.isSplitable() && super.isSplitable(sparkSession, options, path);
    }

    public Option<StructType> inferSchema(SparkSession sparkSession, Map<String, String> options, Seq<FileStatus> files) {
        JSONOptionsInRead parsedOptions = new JSONOptionsInRead(options, sparkSession.sessionState().conf().sessionLocalTimeZone(), sparkSession.sessionState().conf().columnNameOfCorruptRecord());
        Option fullSchemaOption = JsonDataSource$.MODULE$.apply((JSONOptions)parsedOptions).inferSchema(sparkSession, files, (JSONOptions)parsedOptions);
        return fullSchemaOption.map((Function1 & Serializable & scala.Serializable)fullSchema -> {
            StructType newFields = GeoJSONUtils$.MODULE$.updateGeometrySchema((StructType)fullSchema, (DataType)GeometryUDT$.MODULE$);
            return StructType$.MODULE$.apply((Seq)newFields);
        });
    }

    public OutputWriterFactory prepareWrite(SparkSession sparkSession, Job job, Map<String, String> options, StructType dataSchema) {
        Some some;
        StructField structField;
        Configuration conf = job.getConfiguration();
        JSONOptions parsedOptions = new JSONOptions(options, sparkSession.sessionState().conf().sessionLocalTimeZone(), sparkSession.sessionState().conf().columnNameOfCorruptRecord());
        parsedOptions.compressionCodec().foreach((Function1 & Serializable & scala.Serializable)codec -> {
            CompressionCodecs$.MODULE$.setCodecConfiguration(conf, codec);
            return BoxedUnit.UNIT;
        });
        String geometryColumnName = (String)options.getOrElse((Object)"geometry.column", (Function0 & Serializable & scala.Serializable)() -> "geometry");
        Option<StructField> option = SparkCompatUtil$.MODULE$.findNestedField(dataSchema, new StringOps(Predef$.MODULE$.augmentString(geometryColumnName)).split('.'), (Function2<String, String, Object>)SQLConf$.MODULE$.get().resolver());
        if (option instanceof Some && (structField = (StructField)(some = (Some)option).value()) != null) {
            DataType dataType = structField.dataType();
            if (!dataType.acceptsType((DataType)GeometryUDT$.MODULE$)) {
                throw new IllegalArgumentException(new StringBuilder(25).append(geometryColumnName).append(" is not a geometry column").toString());
            }
        } else {
            if (None$.MODULE$.equals(option)) {
                throw new IllegalArgumentException(new StringBuilder(31).append("Column ").append(geometryColumnName).append(" not found in the schema").toString());
            }
            throw new MatchError(option);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        return new OutputWriterFactory(null, parsedOptions, geometryColumnName){
            private final JSONOptions parsedOptions$1;
            private final String geometryColumnName$1;

            public OutputWriter newInstance(String path, StructType dataSchema, TaskAttemptContext context) {
                return new GeoJSONOutputWriter(path, this.parsedOptions$1, dataSchema, this.geometryColumnName$1, context);
            }

            public String getFileExtension(TaskAttemptContext context) {
                return new StringBuilder(5).append(".json").append(CodecStreams$.MODULE$.getCompressionExtension((JobContext)context)).toString();
            }
            {
                this.parsedOptions$1 = parsedOptions$1;
                this.geometryColumnName$1 = geometryColumnName$1;
            }
        };
    }

    public Function1<PartitionedFile, Iterator<InternalRow>> buildReader(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, Map<String, String> options, Configuration hadoopConf) {
        Broadcast broadcastedHadoopConf = sparkSession.sparkContext().broadcast((Object)new SerializableConfiguration(hadoopConf), ClassTag$.MODULE$.apply(SerializableConfiguration.class));
        JSONOptionsInRead parsedOptions = new JSONOptionsInRead(options, sparkSession.sessionState().conf().sessionLocalTimeZone(), sparkSession.sessionState().conf().columnNameOfCorruptRecord());
        StructType actualSchema = StructType$.MODULE$.apply((Seq)requiredSchema.filterNot((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)GeoJSONFileFormat.$anonfun$buildReader$1(parsedOptions, x$1))));
        ExprUtils$.MODULE$.verifyColumnNameOfCorruptRecord(dataSchema, parsedOptions.columnNameOfCorruptRecord());
        StructType alteredSchema = GeoJSONUtils$.MODULE$.updateGeometrySchema(actualSchema, (DataType)StringType$.MODULE$);
        if (requiredSchema.length() == 1) {
            String string = ((StructField)requiredSchema.head()).name();
            String string2 = parsedOptions.columnNameOfCorruptRecord();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                throw new IllegalArgumentException("referenced columns only include the internal corrupt record column, this is not allowed");
            }
        }
        return (Function1 & Serializable & scala.Serializable)file -> {
            JacksonParser parser = SparkCompatUtil$.MODULE$.constructJacksonParser((DataType)alteredSchema, (JSONOptions)parsedOptions, true);
            JsonDataSource dataSource = JsonDataSource$.MODULE$.apply((JSONOptions)parsedOptions);
            return SparkCompatUtil$.MODULE$.readFile(dataSource, ((SerializableConfiguration)broadcastedHadoopConf.value()).value(), (PartitionedFile)file, parser, actualSchema).map((Function1 & Serializable & scala.Serializable)row -> {
                void var2_2;
                InternalRow newRow = GeoJSONUtils$.MODULE$.convertGeoJsonToGeometry((InternalRow)row, alteredSchema);
                return var2_2;
            });
        };
    }

    public String toString() {
        return "GEOJSON";
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public boolean equals(Object other) {
        return other instanceof GeoJSONFileFormat;
    }

    public boolean supportDataType(DataType dataType) {
        boolean bl;
        DataType dataType2 = dataType;
        if (dataType2 instanceof AtomicType) {
            bl = true;
        } else if (dataType2 instanceof StructType) {
            StructType structType = (StructType)dataType2;
            bl = structType.forall((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)this.supportDataType(f.dataType())));
        } else if (dataType2 instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType2;
            DataType elementType = arrayType.elementType();
            bl = this.supportDataType(elementType);
        } else if (dataType2 instanceof MapType) {
            MapType mapType = (MapType)dataType2;
            DataType keyType = mapType.keyType();
            DataType valueType = mapType.valueType();
            bl = this.supportDataType(keyType) && this.supportDataType(valueType);
        } else if (((Object)((Object)GeometryUDT$.MODULE$)).equals(dataType2)) {
            bl = true;
        } else if (((Object)((Object)RasterUDT$.MODULE$)).equals(dataType2)) {
            bl = false;
        } else if (dataType2 instanceof UserDefinedType) {
            UserDefinedType userDefinedType = (UserDefinedType)dataType2;
            bl = this.supportDataType(userDefinedType.sqlType());
        } else {
            bl = dataType2 instanceof NullType;
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$buildReader$1(JSONOptionsInRead parsedOptions$2, StructField x$1) {
        String string = x$1.name();
        String string2 = parsedOptions$2.columnNameOfCorruptRecord();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public GeoJSONFileFormat() {
        this.shortName = "geojson";
    }
}

