/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.index.hprtree;

import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.shape.fractal.HilbertCode;

public class HilbertEncoder {
    private int level;
    private double minx;
    private double miny;
    private double strideX;
    private double strideY;

    public HilbertEncoder(int level, Envelope extent) {
        this.level = level;
        int hside = (int)Math.pow(2.0, level) - 1;
        this.minx = extent.getMinX();
        this.strideX = extent.getWidth() / (double)hside;
        this.miny = extent.getMinY();
        this.strideY = extent.getHeight() / (double)hside;
    }

    public int encode(Envelope env) {
        double midx = env.getWidth() / 2.0 + env.getMinX();
        int x = (int)((midx - this.minx) / this.strideX);
        double midy = env.getHeight() / 2.0 + env.getMinY();
        int y = (int)((midy - this.miny) / this.strideY);
        return HilbertCode.encode(this.level, x, y);
    }
}

