/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.shaded.jiffle.parser;

import it.geosolutions.jaiext.jiffle.runtime.JiffleRuntime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.sedona.shaded.antlr.tree.ParseTree;
import org.apache.sedona.shaded.jiffle.parser.AbstractModelWorker;
import org.apache.sedona.shaded.jiffle.parser.GlobalScope;
import org.apache.sedona.shaded.jiffle.parser.InternalCompilerException;
import org.apache.sedona.shaded.jiffle.parser.JiffleParser;
import org.apache.sedona.shaded.jiffle.parser.JiffleType;
import org.apache.sedona.shaded.jiffle.parser.Symbol;
import org.apache.sedona.shaded.jiffle.parser.SymbolScope;
import org.apache.sedona.shaded.jiffle.parser.TreeNodeProperties;
import org.apache.sedona.shaded.jiffle.parser.node.Band;
import org.apache.sedona.shaded.jiffle.parser.node.BinaryExpression;
import org.apache.sedona.shaded.jiffle.parser.node.Break;
import org.apache.sedona.shaded.jiffle.parser.node.BreakIf;
import org.apache.sedona.shaded.jiffle.parser.node.DefaultScalarValue;
import org.apache.sedona.shaded.jiffle.parser.node.Expression;
import org.apache.sedona.shaded.jiffle.parser.node.GlobalVars;
import org.apache.sedona.shaded.jiffle.parser.node.IfElse;
import org.apache.sedona.shaded.jiffle.parser.node.ListAppend;
import org.apache.sedona.shaded.jiffle.parser.node.ListLiteral;
import org.apache.sedona.shaded.jiffle.parser.node.LoopInLiteralList;
import org.apache.sedona.shaded.jiffle.parser.node.LoopInRange;
import org.apache.sedona.shaded.jiffle.parser.node.LoopInVariable;
import org.apache.sedona.shaded.jiffle.parser.node.NodeException;
import org.apache.sedona.shaded.jiffle.parser.node.ScalarLiteral;
import org.apache.sedona.shaded.jiffle.parser.node.Script;
import org.apache.sedona.shaded.jiffle.parser.node.SetDestValue;
import org.apache.sedona.shaded.jiffle.parser.node.SimpleStatement;
import org.apache.sedona.shaded.jiffle.parser.node.Statement;
import org.apache.sedona.shaded.jiffle.parser.node.StatementList;
import org.apache.sedona.shaded.jiffle.parser.node.Until;
import org.apache.sedona.shaded.jiffle.parser.node.Variable;
import org.apache.sedona.shaded.jiffle.parser.node.While;

public class RuntimeModelWorker
extends AbstractModelWorker {
    private final TreeNodeProperties<JiffleType> types;
    private final TreeNodeProperties<SymbolScope> scopes;
    private final Map<String, String> options;
    private final Set<VariableKey> declaredVariables = new HashSet<VariableKey>();
    private final Map<String, Integer> destImageBands = new HashMap<String, Integer>();
    private JiffleParser.InitBlockContext initBlockContext = null;
    private Script script;

    public RuntimeModelWorker(ParseTree tree, Map<String, String> options, TreeNodeProperties<JiffleType> types, TreeNodeProperties<SymbolScope> scopes) {
        super(tree);
        this.types = types;
        this.scopes = scopes;
        this.options = options;
        this.walkTree();
    }

    @Override
    public void exitScript(JiffleParser.ScriptContext ctx) {
        StatementList stmts = this.getAsType(ctx.body(), StatementList.class);
        GlobalVars globals = this.initBlockContext == null ? new GlobalVars() : this.getAsType(this.initBlockContext, GlobalVars.class);
        GlobalScope globalScope = (GlobalScope)this.scopes.get(ctx);
        Set<String> sourceImages = globalScope.getByType(Symbol.Type.SOURCE_IMAGE);
        Set<String> destImages = globalScope.getByType(Symbol.Type.DEST_IMAGE);
        this.script = new Script(this.options, sourceImages, destImages, globals, stmts, this.readsOptimizer);
        this.set(ctx, this.script);
    }

    @Override
    public void exitBody(JiffleParser.BodyContext ctx) {
        ArrayList<Statement> statements = new ArrayList<Statement>();
        for (JiffleParser.StatementContext sctx : ctx.statement()) {
            statements.add(this.getAsType(sctx, Statement.class));
        }
        this.set(ctx, new StatementList(statements));
    }

    @Override
    public void exitInitBlock(JiffleParser.InitBlockContext ctx) {
        ArrayList<BinaryExpression> inits = new ArrayList<BinaryExpression>();
        List<JiffleParser.VarDeclarationContext> decls = ctx.varDeclaration();
        if (decls != null) {
            try {
                for (JiffleParser.VarDeclarationContext dc : decls) {
                    String name = dc.ID().getText();
                    JiffleParser.ExpressionContext exprCtx = dc.expression();
                    Expression value = exprCtx == null ? new DefaultScalarValue() : this.getAsType(exprCtx, Expression.class);
                    inits.add(new BinaryExpression(50, new Variable(name, JiffleType.D), value));
                }
            }
            catch (NodeException ex) {
                this.messages.error(ctx.getStart(), ex.getError());
            }
        }
        this.set(ctx, new GlobalVars(inits));
        this.initBlockContext = ctx;
    }

    @Override
    public void exitExprStmt(JiffleParser.ExprStmtContext ctx) {
        this.set(ctx, new SimpleStatement(this.getAsType(ctx.expression(), Expression.class)));
    }

    @Override
    public void exitExpressionList(JiffleParser.ExpressionListContext ctx) {
    }

    @Override
    public void exitAssignExpr(JiffleParser.AssignExprContext ctx) {
        this.set(ctx, this.get(ctx.assignment()));
    }

    @Override
    public void exitAssignment(JiffleParser.AssignmentContext ctx) {
        String varName = ctx.assignmentTarget().ID().getText();
        Band band = null;
        if (ctx.assignmentTarget().bandSpecifier() != null) {
            band = this.getAsType(ctx.assignmentTarget().bandSpecifier(), Band.class);
        }
        SymbolScope scope = this.getScope(ctx);
        Symbol symbol = scope.get(varName);
        SymbolScope declaringScope = scope.getDeclaringScope(varName);
        boolean declare = this.checkAndSetDeclared(declaringScope, varName);
        int opType = ctx.op.getType();
        Expression expr = this.getAsType(ctx.expression(), Expression.class);
        try {
            switch (symbol.getType()) {
                case DEST_IMAGE: {
                    this.updateDestinationImageBands(varName, band);
                    this.set(ctx, new SetDestValue(varName, band, expr));
                    break;
                }
                case LIST: {
                    this.set(ctx, new BinaryExpression(opType, new Variable(varName, JiffleType.LIST), expr, declare));
                    break;
                }
                case SCALAR: {
                    this.set(ctx, new BinaryExpression(opType, new Variable(varName, JiffleType.D), expr, declare));
                    break;
                }
                default: {
                    throw new InternalCompilerException("Invalid assignment to " + varName);
                }
            }
        }
        catch (NodeException ex) {
            this.messages.error(ctx.getStart(), ex.getError());
        }
    }

    private void updateDestinationImageBands(String varName, Band band) {
        Expression index;
        Integer bandNumber = band == null ? Integer.valueOf(1) : ((index = band.getIndex()) instanceof ScalarLiteral ? Integer.valueOf(Integer.valueOf(((ScalarLiteral)index).getValue()) + 1) : JiffleRuntime.DYNAMIC_BANDS);
        Integer current = this.destImageBands.get(varName);
        if (current == JiffleRuntime.DYNAMIC_BANDS || bandNumber == JiffleRuntime.DYNAMIC_BANDS) {
            this.destImageBands.put(varName, JiffleRuntime.DYNAMIC_BANDS);
        } else if (current == null || bandNumber > current) {
            this.destImageBands.put(varName, bandNumber);
        }
    }

    private boolean checkAndSetDeclared(SymbolScope scope, String varName) {
        if (scope instanceof GlobalScope) {
            return false;
        }
        return this.declaredVariables.add(new VariableKey(scope, varName));
    }

    @Override
    protected SymbolScope getScope(ParseTree ctx) {
        if (ctx != null) {
            SymbolScope s2 = (SymbolScope)this.scopes.get(ctx);
            return s2 != null ? s2 : this.getScope(ctx.getParent());
        }
        throw new IllegalStateException("Compiler error: failed to find symbol scope");
    }

    @Override
    public void exitUntilStmt(JiffleParser.UntilStmtContext ctx) {
        Expression condition = this.getAsType(ctx.parenExpression().expression(), Expression.class);
        Statement statement = this.getAsType(ctx.statement(), Statement.class);
        this.set(ctx, new Until(condition, statement));
    }

    @Override
    public void exitBreakifStmt(JiffleParser.BreakifStmtContext ctx) {
        Expression condition = this.getAsType(ctx.expression(), Expression.class);
        this.set(ctx, new BreakIf(condition));
    }

    @Override
    public void exitBlock(JiffleParser.BlockContext ctx) {
        List<JiffleParser.StatementContext> contexts = ctx.statement();
        ArrayList<Statement> statements = new ArrayList<Statement>();
        for (JiffleParser.StatementContext context : contexts) {
            Statement st = this.getAsType(context, Statement.class);
            statements.add(st);
        }
        this.set(ctx, new StatementList(statements));
    }

    @Override
    public void exitBlockStmt(JiffleParser.BlockStmtContext ctx) {
        this.set(ctx, this.get(ctx.block()));
    }

    public Script getScriptNode() {
        return this.script;
    }

    @Override
    public void exitIfStmt(JiffleParser.IfStmtContext ctx) {
        Expression condition = this.getAsType(ctx.parenExpression().expression(), Expression.class);
        List<JiffleParser.StatementContext> statements = ctx.statement();
        Statement ifBlock = this.getAsType(statements.get(0), Statement.class);
        Statement elseBlock = null;
        if (statements.size() > 1) {
            elseBlock = this.getAsType(statements.get(1), Statement.class);
        }
        this.set(ctx, new IfElse(condition, ifBlock, elseBlock));
    }

    @Override
    public void exitListAppendStmt(JiffleParser.ListAppendStmtContext ctx) {
        String varName = ctx.ID().getText();
        Expression expression = this.getAsType(ctx.expression(), Expression.class);
        this.set(ctx, new ListAppend(new Variable(varName, JiffleType.LIST), expression));
    }

    @Override
    public void exitForeachStmt(JiffleParser.ForeachStmtContext ctx) {
        String varName = ctx.ID().getText();
        JiffleParser.RangeContext range = ctx.loopSet().range();
        Variable loopVariable = new Variable(varName, JiffleType.D);
        Statement statement = this.getAsType(ctx.statement(), Statement.class);
        if (ctx.loopSet().ID() != null) {
            Variable listVariable = new Variable(ctx.loopSet().ID().getText(), JiffleType.LIST);
            this.set(ctx, new LoopInVariable(loopVariable, listVariable, statement));
        } else if (range != null) {
            Expression low = this.getAsType(range.expression(0), Expression.class);
            Expression high = this.getAsType(range.expression(1), Expression.class);
            this.set(ctx, new LoopInRange(loopVariable, low, high, statement));
        } else {
            ListLiteral listLiteral = this.getAsType(ctx.loopSet().listLiteral(), ListLiteral.class);
            this.set(ctx, new LoopInLiteralList(loopVariable, listLiteral, statement));
        }
    }

    @Override
    public void exitBreakStmt(JiffleParser.BreakStmtContext ctx) {
        this.set(ctx, new Break());
    }

    @Override
    public void exitWhileStmt(JiffleParser.WhileStmtContext ctx) {
        Expression condition = this.getAsType(ctx.parenExpression().expression(), Expression.class);
        Statement statement = this.getAsType(ctx.statement(), Statement.class);
        this.set(ctx, new While(condition, statement));
    }

    public Map<String, Integer> getDestinationBands() {
        return this.destImageBands;
    }

    private static class VariableKey {
        SymbolScope scope;
        String name;

        public VariableKey(SymbolScope scope, String name) {
            this.scope = scope;
            this.name = name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            VariableKey that = (VariableKey)o;
            return Objects.equals(this.scope, that.scope) && Objects.equals(this.name, that.name);
        }

        public int hashCode() {
            return Objects.hash(this.scope, this.name);
        }
    }
}

