/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.agent.plugin.tracing.opentelemetry.advice;

import org.apache.shardingsphere.agent.api.advice.TargetAdviceMethod;
import org.apache.shardingsphere.agent.api.advice.TargetAdviceObject;
import org.apache.shardingsphere.agent.plugin.tracing.core.advice.TracingSQLParserEngineAdvice;
import org.apache.shardingsphere.shade.io.opentelemetry.api.GlobalOpenTelemetry;
import org.apache.shardingsphere.shade.io.opentelemetry.api.trace.Span;
import org.apache.shardingsphere.shade.io.opentelemetry.api.trace.SpanBuilder;
import org.apache.shardingsphere.shade.io.opentelemetry.api.trace.StatusCode;
import org.apache.shardingsphere.shade.io.opentelemetry.api.trace.Tracer;
import org.apache.shardingsphere.shade.io.opentelemetry.context.Context;

public final class OpenTelemetrySQLParserEngineAdvice
extends TracingSQLParserEngineAdvice<Span> {
    @Override
    protected Object recordSQLParseInfo(Span parentSpan, TargetAdviceObject target, String sql) {
        Tracer tracer = GlobalOpenTelemetry.getTracer("shardingsphere-agent");
        SpanBuilder spanBuilder = tracer.spanBuilder("/ShardingSphere/parseSQL/").setAttribute("component", "ShardingSphere").setAttribute("db.statement", sql).setAttribute("span.kind", "internal");
        spanBuilder.setParent(Context.current().with(parentSpan));
        Span result = spanBuilder.startSpan();
        target.setAttachment((Object)result);
        return result;
    }

    public void afterMethod(TargetAdviceObject target, TargetAdviceMethod method, Object[] args2, Object result, String pluginType) {
        Span span = (Span)target.getAttachment();
        span.setStatus(StatusCode.OK);
        span.end();
    }

    public void onThrowing(TargetAdviceObject target, TargetAdviceMethod method, Object[] args2, Throwable throwable, String pluginType) {
        Span span = (Span)target.getAttachment();
        span.setStatus(StatusCode.ERROR).recordException(throwable);
        span.end();
    }
}

