/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics;

import java.util.List;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.shardingsphere.shade.io.opentelemetry.api.common.AttributeKey;
import org.apache.shardingsphere.shade.io.opentelemetry.api.common.Attributes;
import org.apache.shardingsphere.shade.io.opentelemetry.api.incubator.metrics.ExtendedLongCounter;
import org.apache.shardingsphere.shade.io.opentelemetry.api.incubator.metrics.ExtendedLongCounterBuilder;
import org.apache.shardingsphere.shade.io.opentelemetry.api.metrics.DoubleCounterBuilder;
import org.apache.shardingsphere.shade.io.opentelemetry.api.metrics.LongCounterBuilder;
import org.apache.shardingsphere.shade.io.opentelemetry.api.metrics.ObservableLongCounter;
import org.apache.shardingsphere.shade.io.opentelemetry.api.metrics.ObservableLongMeasurement;
import org.apache.shardingsphere.shade.io.opentelemetry.context.Context;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.internal.ThrottlingLogger;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.AbstractInstrument;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.InstrumentBuilder;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.InstrumentType;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.InstrumentValueType;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.SdkDoubleCounter;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.internal.state.MeterProviderSharedState;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.internal.state.MeterSharedState;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.internal.state.WriteableMetricStorage;

final class SdkLongCounter
extends AbstractInstrument
implements ExtendedLongCounter {
    private static final Logger logger = Logger.getLogger(SdkLongCounter.class.getName());
    private final ThrottlingLogger throttlingLogger = new ThrottlingLogger(logger);
    private final MeterSharedState meterSharedState;
    private final WriteableMetricStorage storage;

    private SdkLongCounter(InstrumentDescriptor descriptor, MeterSharedState meterSharedState, WriteableMetricStorage storage) {
        super(descriptor);
        this.meterSharedState = meterSharedState;
        this.storage = storage;
    }

    @Override
    public void add(long increment, Attributes attributes, Context context) {
        if (increment < 0L) {
            this.throttlingLogger.log(Level.WARNING, "Counters can only increase. Instrument " + this.getDescriptor().getName() + " has recorded a negative value.");
            return;
        }
        this.storage.recordLong(increment, attributes, context);
    }

    @Override
    public void add(long increment, Attributes attributes) {
        this.add(increment, attributes, Context.current());
    }

    @Override
    public void add(long increment) {
        this.add(increment, Attributes.empty());
    }

    @Override
    public boolean isEnabled() {
        return this.meterSharedState.isMeterEnabled() && this.storage.isEnabled();
    }

    static final class SdkLongCounterBuilder
    implements ExtendedLongCounterBuilder {
        private final InstrumentBuilder builder;

        SdkLongCounterBuilder(MeterProviderSharedState meterProviderSharedState, MeterSharedState meterSharedState, String name) {
            this.builder = new InstrumentBuilder(name, InstrumentType.COUNTER, InstrumentValueType.LONG, meterProviderSharedState, meterSharedState);
        }

        @Override
        public LongCounterBuilder setDescription(String description) {
            this.builder.setDescription(description);
            return this;
        }

        @Override
        public LongCounterBuilder setUnit(String unit) {
            this.builder.setUnit(unit);
            return this;
        }

        @Override
        public SdkLongCounter build() {
            return this.builder.buildSynchronousInstrument((x$0, x$1, x$2) -> new SdkLongCounter(x$0, x$1, x$2));
        }

        @Override
        public DoubleCounterBuilder ofDoubles() {
            return this.builder.swapBuilder(SdkDoubleCounter.SdkDoubleCounterBuilder::new);
        }

        @Override
        public ObservableLongCounter buildWithCallback(Consumer<ObservableLongMeasurement> callback) {
            return this.builder.buildLongAsynchronousInstrument(InstrumentType.OBSERVABLE_COUNTER, callback);
        }

        @Override
        public ObservableLongMeasurement buildObserver() {
            return this.builder.buildObservableMeasurement(InstrumentType.OBSERVABLE_COUNTER);
        }

        @Override
        public ExtendedLongCounterBuilder setAttributesAdvice(List<AttributeKey<?>> attributes) {
            this.builder.setAdviceAttributes(attributes);
            return this;
        }

        public String toString() {
            return this.builder.toStringHelper(this.getClass().getSimpleName());
        }
    }
}

