/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.database.mysql.checker;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.shardingsphere.infra.database.core.checker.DialectDatabasePrivilegeChecker;
import org.apache.shardingsphere.infra.database.core.checker.PrivilegeCheckType;
import org.apache.shardingsphere.infra.database.core.exception.CheckDatabaseEnvironmentFailedException;
import org.apache.shardingsphere.infra.database.core.exception.MissingRequiredPrivilegeException;

public final class MySQLDatabasePrivilegeChecker
implements DialectDatabasePrivilegeChecker {
    private static final String SHOW_GRANTS_SQL = "SHOW GRANTS";
    private static final int MYSQL_MAJOR_VERSION_8 = 8;
    private static final String[][] PIPELINE_REQUIRED_PRIVILEGES = new String[][]{{"ALL PRIVILEGES", "ON *.*"}, {"REPLICATION SLAVE", "REPLICATION CLIENT", "ON *.*"}, {"REPLICATION SLAVE", "BINLOG MONITOR", "ON *.*"}};
    private static final String[][] XA_REQUIRED_PRIVILEGES = new String[][]{{"ALL PRIVILEGES", "ON *.*"}, {"XA_RECOVER_ADMIN", "ON *.*"}};
    private static final Map<PrivilegeCheckType, Collection<String>> REQUIRED_PRIVILEGES_FOR_MESSAGE = new EnumMap<PrivilegeCheckType, Collection<String>>(PrivilegeCheckType.class);

    public void check(DataSource dataSource, PrivilegeCheckType privilegeCheckType) {
        try (Connection connection = dataSource.getConnection();){
            if (PrivilegeCheckType.XA == privilegeCheckType && 8 != connection.getMetaData().getDatabaseMajorVersion()) {
                return;
            }
            this.checkPrivilege(connection, privilegeCheckType);
        }
        catch (SQLException ex) {
            throw new CheckDatabaseEnvironmentFailedException(ex);
        }
    }

    private void checkPrivilege(Connection connection, PrivilegeCheckType privilegeCheckType) {
        try (PreparedStatement preparedStatement = connection.prepareStatement(SHOW_GRANTS_SQL);
             ResultSet resultSet = preparedStatement.executeQuery();){
            while (true) {
                if (resultSet.next()) {
                    String privilege = resultSet.getString(1).toUpperCase();
                    if (!this.matchPrivileges(privilege, this.getRequiredPrivileges(connection, privilegeCheckType))) continue;
                    return;
                    continue;
                }
                break;
            }
        }
        catch (SQLException ex) {
            throw new CheckDatabaseEnvironmentFailedException(ex);
        }
        throw new MissingRequiredPrivilegeException(REQUIRED_PRIVILEGES_FOR_MESSAGE.get(privilegeCheckType));
    }

    private String[][] getRequiredPrivileges(Connection connection, PrivilegeCheckType privilegeCheckType) throws SQLException {
        switch (privilegeCheckType) {
            case PIPELINE: {
                return PIPELINE_REQUIRED_PRIVILEGES;
            }
            case SELECT: {
                return this.getSelectRequiredPrivilege(connection);
            }
            case XA: {
                return XA_REQUIRED_PRIVILEGES;
            }
        }
        return new String[0][0];
    }

    private String[][] getSelectRequiredPrivilege(Connection connection) throws SQLException {
        return new String[][]{{"ALL PRIVILEGES", "ON *.*"}, {"SELECT", "ON *.*"}, {"SELECT", String.format("ON `%s`.*", connection.getCatalog()).toUpperCase()}};
    }

    private boolean matchPrivileges(String grantedPrivileges, String[][] requiredPrivileges) {
        return Arrays.stream(requiredPrivileges).anyMatch(each -> Arrays.stream(each).allMatch(grantedPrivileges::contains));
    }

    public String getDatabaseType() {
        return "MySQL";
    }

    static {
        REQUIRED_PRIVILEGES_FOR_MESSAGE.put(PrivilegeCheckType.PIPELINE, Arrays.asList("REPLICATION SLAVE", "REPLICATION CLIENT"));
        REQUIRED_PRIVILEGES_FOR_MESSAGE.put(PrivilegeCheckType.SELECT, Collections.singleton("SELECT ON DATABASE"));
        REQUIRED_PRIVILEGES_FOR_MESSAGE.put(PrivilegeCheckType.XA, Collections.singleton("XA_RECOVER_ADMIN"));
    }
}

