/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.database.mysql.connector;

import java.util.Properties;
import org.apache.shardingsphere.infra.database.core.connector.ConnectionProperties;
import org.apache.shardingsphere.infra.database.core.connector.ConnectionPropertiesParser;
import org.apache.shardingsphere.infra.database.core.connector.StandardConnectionProperties;
import org.apache.shardingsphere.infra.database.core.connector.url.JdbcUrl;
import org.apache.shardingsphere.infra.database.core.connector.url.StandardJdbcUrlParser;

public final class MySQLConnectionPropertiesParser
implements ConnectionPropertiesParser {
    private static final int DEFAULT_PORT = 3306;

    public ConnectionProperties parse(String url, String username, String catalog) {
        JdbcUrl jdbcUrl = new StandardJdbcUrlParser().parse(url);
        return new StandardConnectionProperties(jdbcUrl.getHostname(), jdbcUrl.getPort(3306), null == catalog ? jdbcUrl.getDatabase() : catalog, null, jdbcUrl.getQueryProperties(), this.buildDefaultQueryProperties());
    }

    private Properties buildDefaultQueryProperties() {
        Properties result = new Properties();
        result.setProperty("useServerPrepStmts", Boolean.TRUE.toString());
        result.setProperty("cachePrepStmts", Boolean.TRUE.toString());
        result.setProperty("prepStmtCacheSize", "8192");
        result.setProperty("prepStmtCacheSqlLimit", "2048");
        result.setProperty("useLocalSessionState", Boolean.TRUE.toString());
        result.setProperty("rewriteBatchedStatements", Boolean.TRUE.toString());
        result.setProperty("cacheResultSetMetadata", Boolean.FALSE.toString());
        result.setProperty("cacheServerConfiguration", Boolean.TRUE.toString());
        result.setProperty("elideSetAutoCommits", Boolean.TRUE.toString());
        result.setProperty("maintainTimeStats", Boolean.FALSE.toString());
        result.setProperty("netTimeoutForStreamingResults", "0");
        result.setProperty("tinyInt1isBit", Boolean.FALSE.toString());
        result.setProperty("useSSL", Boolean.FALSE.toString());
        result.setProperty("zeroDateTimeBehavior", "round");
        return result;
    }

    public String getDatabaseType() {
        return "MySQL";
    }
}

