/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.event.subscriber.dispatch;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.Subscribe;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.rule.RuleConfiguration;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;
import org.apache.shardingsphere.infra.util.eventbus.EventSubscriber;
import org.apache.shardingsphere.mode.event.dispatch.config.AlterGlobalRuleConfigurationEvent;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.mode.spi.RuleConfigurationPersistDecorator;

public final class GlobalRuleConfigurationEventSubscriber
implements EventSubscriber {
    private final ContextManager contextManager;

    @Subscribe
    public synchronized void renew(AlterGlobalRuleConfigurationEvent event) {
        Preconditions.checkArgument((boolean)event.getActiveVersion().equals(this.contextManager.getPersistServiceFacade().getMetaDataPersistService().getMetaDataVersionPersistService().getActiveVersionByFullPath(event.getActiveVersionKey())), (String)"Invalid active version: %s of key: %s", (Object)event.getActiveVersion(), (Object)event.getActiveVersionKey());
        Optional ruleConfig = this.contextManager.getPersistServiceFacade().getMetaDataPersistService().getGlobalRuleService().load(event.getRuleSimpleName());
        Preconditions.checkArgument((boolean)ruleConfig.isPresent(), (String)"Can not find rule configuration with name: %s", (Object)event.getRuleSimpleName());
        this.contextManager.getMetaDataContextManager().getGlobalConfigurationManager().alterGlobalRuleConfiguration(TypedSPILoader.findService(RuleConfigurationPersistDecorator.class, ruleConfig.getClass()).map(optional -> optional.restore((RuleConfiguration)ruleConfig.get())).orElse((RuleConfiguration)ruleConfig.get()));
    }

    @Generated
    public GlobalRuleConfigurationEventSubscriber(ContextManager contextManager) {
        this.contextManager = contextManager;
    }
}

