/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.algorithm.sharding.datetime;

import com.google.common.collect.Range;
import java.text.DecimalFormat;
import java.text.ParsePosition;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.format.DateTimeParseException;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import lombok.Generated;
import org.apache.shardingsphere.infra.algorithm.core.ShardingSphereAlgorithm;
import org.apache.shardingsphere.infra.algorithm.core.exception.AlgorithmInitializationException;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.util.datetime.DateTimeFormatterFactory;
import org.apache.shardingsphere.sharding.algorithm.sharding.ShardingAutoTableAlgorithmUtils;
import org.apache.shardingsphere.sharding.api.sharding.ShardingAutoTableAlgorithm;
import org.apache.shardingsphere.sharding.api.sharding.standard.PreciseShardingValue;
import org.apache.shardingsphere.sharding.api.sharding.standard.RangeShardingValue;
import org.apache.shardingsphere.sharding.api.sharding.standard.StandardShardingAlgorithm;
import org.apache.shardingsphere.sharding.exception.data.InvalidDatetimeFormatException;
import org.apache.shardingsphere.sharding.exception.data.NullShardingValueException;

public final class AutoIntervalShardingAlgorithm
implements StandardShardingAlgorithm<Comparable<?>>,
ShardingAutoTableAlgorithm {
    private static final String DATE_TIME_LOWER_KEY = "datetime-lower";
    private static final String DATE_TIME_UPPER_KEY = "datetime-upper";
    private static final String SHARDING_SECONDS_KEY = "sharding-seconds";
    private LocalDateTime dateTimeLower;
    private long shardingSeconds;
    private int autoTablesAmount;

    public void init(Properties props) {
        this.dateTimeLower = this.getDateTime(props);
        this.shardingSeconds = this.getShardingSeconds(props);
        this.autoTablesAmount = (int)(Math.ceil(this.parseDate((Comparable<?>)((Object)props.getProperty(DATE_TIME_UPPER_KEY))) / this.shardingSeconds) + 2.0);
    }

    private LocalDateTime getDateTime(Properties props) {
        String value = props.getProperty(DATE_TIME_LOWER_KEY);
        ShardingSpherePreconditions.checkNotNull((Object)value, () -> new AlgorithmInitializationException((ShardingSphereAlgorithm)this, String.format("%s cannot be null.", DATE_TIME_LOWER_KEY), new Object[0]));
        try {
            return LocalDateTime.parse(value, DateTimeFormatterFactory.getStandardFormatter());
        }
        catch (DateTimeParseException ignored) {
            throw new InvalidDatetimeFormatException(DATE_TIME_LOWER_KEY, value, "yyyy-MM-dd HH:mm:ss");
        }
    }

    private long getShardingSeconds(Properties props) {
        ShardingSpherePreconditions.checkContainsKey((Map)props, (Object)SHARDING_SECONDS_KEY, () -> new AlgorithmInitializationException((ShardingSphereAlgorithm)this, String.format("%s cannot be null.", SHARDING_SECONDS_KEY), new Object[0]));
        return Long.parseLong(props.getProperty(SHARDING_SECONDS_KEY));
    }

    public String doSharding(Collection<String> availableTargetNames, PreciseShardingValue<Comparable<?>> shardingValue) {
        ShardingSpherePreconditions.checkNotNull((Object)shardingValue.getValue(), NullShardingValueException::new);
        String tableNameSuffix = String.valueOf(this.doSharding(this.parseDate((Comparable)shardingValue.getValue())));
        return ShardingAutoTableAlgorithmUtils.findMatchedTargetName(availableTargetNames, tableNameSuffix, shardingValue.getDataNodeInfo()).orElse(null);
    }

    public Collection<String> doSharding(Collection<String> availableTargetNames, RangeShardingValue<Comparable<?>> shardingValue) {
        LinkedHashSet<String> result = new LinkedHashSet<String>(availableTargetNames.size(), 1.0f);
        int firstPartition = this.getFirstPartition(shardingValue.getValueRange());
        int lastPartition = this.getLastPartition(shardingValue.getValueRange());
        for (int i = firstPartition; i <= lastPartition; ++i) {
            String suffix = String.valueOf(i);
            ShardingAutoTableAlgorithmUtils.findMatchedTargetName(availableTargetNames, suffix, shardingValue.getDataNodeInfo()).ifPresent(result::add);
        }
        return result;
    }

    private int doSharding(long shardingValue) {
        String position = new DecimalFormat("0.00").format((double)shardingValue / (double)this.shardingSeconds);
        return Math.min(Math.max(0, (int)Math.ceil(Double.parseDouble(position))), this.autoTablesAmount - 1);
    }

    private int getFirstPartition(Range<Comparable<?>> valueRange) {
        return valueRange.hasLowerBound() ? this.doSharding(this.parseDate(valueRange.lowerEndpoint())) : 0;
    }

    private int getLastPartition(Range<Comparable<?>> valueRange) {
        return valueRange.hasUpperBound() ? this.doSharding(this.parseDate(valueRange.upperEndpoint())) : this.autoTablesAmount - 1;
    }

    private long parseDate(Comparable<?> shardingValue) {
        LocalDateTime dateValue = LocalDateTime.from(DateTimeFormatterFactory.getStandardFormatter().parse((CharSequence)shardingValue.toString(), new ParsePosition(0)));
        return Duration.between(this.dateTimeLower, dateValue).toMillis() / 1000L;
    }

    public String getType() {
        return "AUTO_INTERVAL";
    }

    @Generated
    public int getAutoTablesAmount() {
        return this.autoTablesAmount;
    }
}

