/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.merge;

import java.util.Optional;
import org.apache.shardingsphere.encrypt.merge.dal.EncryptDALResultDecorator;
import org.apache.shardingsphere.encrypt.merge.dql.EncryptDQLResultDecorator;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.merge.engine.decorator.ResultDecorator;
import org.apache.shardingsphere.infra.merge.engine.decorator.ResultDecoratorEngine;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.rule.RuleMetaData;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dal.DALStatement;

public final class EncryptResultDecoratorEngine
implements ResultDecoratorEngine<EncryptRule> {
    public Optional<ResultDecorator<EncryptRule>> newInstance(RuleMetaData globalRuleMetaData, ShardingSphereDatabase database, EncryptRule encryptRule, ConfigurationProperties props, SQLStatementContext sqlStatementContext) {
        if (sqlStatementContext instanceof SelectStatementContext) {
            return Optional.of(new EncryptDQLResultDecorator(database, encryptRule, (SelectStatementContext)sqlStatementContext));
        }
        if (sqlStatementContext.getSqlStatement() instanceof DALStatement) {
            return Optional.of(new EncryptDALResultDecorator(globalRuleMetaData));
        }
        return Optional.empty();
    }

    public int getOrder() {
        return 15;
    }

    public Class<EncryptRule> getTypeClass() {
        return EncryptRule.class;
    }
}

