/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.distsql.handler.checker;

import com.cedarsoftware.util.CaseInsensitiveSet;
import com.google.common.base.Splitter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.distsql.segment.AlgorithmSegment;
import org.apache.shardingsphere.infra.algorithm.core.ShardingSphereAlgorithm;
import org.apache.shardingsphere.infra.algorithm.core.exception.AlgorithmInitializationException;
import org.apache.shardingsphere.infra.algorithm.core.exception.InvalidAlgorithmConfigurationException;
import org.apache.shardingsphere.infra.algorithm.keygen.core.KeyGenerateAlgorithm;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.kernel.metadata.resource.storageunit.MissingRequiredStorageUnitsException;
import org.apache.shardingsphere.infra.exception.kernel.metadata.rule.DuplicateRuleException;
import org.apache.shardingsphere.infra.exception.kernel.metadata.rule.InvalidRuleConfigurationException;
import org.apache.shardingsphere.infra.exception.kernel.metadata.rule.MissingRequiredRuleException;
import org.apache.shardingsphere.infra.expr.core.InlineExpressionParserFactory;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.rule.attribute.datasource.DataSourceMapperRuleAttribute;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.rule.ShardingAutoTableRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.rule.ShardingTableReferenceRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.rule.ShardingTableRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.keygen.KeyGenerateStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.ComplexShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.NoneShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.ShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.StandardShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.sharding.ShardingAutoTableAlgorithm;
import org.apache.shardingsphere.sharding.distsql.handler.converter.ShardingTableRuleStatementConverter;
import org.apache.shardingsphere.sharding.distsql.handler.enums.ShardingStrategyType;
import org.apache.shardingsphere.sharding.distsql.segment.strategy.AuditStrategySegment;
import org.apache.shardingsphere.sharding.distsql.segment.strategy.KeyGenerateStrategySegment;
import org.apache.shardingsphere.sharding.distsql.segment.strategy.ShardingAuditorSegment;
import org.apache.shardingsphere.sharding.distsql.segment.strategy.ShardingStrategySegment;
import org.apache.shardingsphere.sharding.distsql.segment.table.AbstractTableRuleSegment;
import org.apache.shardingsphere.sharding.distsql.segment.table.AutoTableRuleSegment;
import org.apache.shardingsphere.sharding.distsql.segment.table.TableRuleSegment;
import org.apache.shardingsphere.sharding.exception.algorithm.ShardingAlgorithmClassImplementationException;
import org.apache.shardingsphere.sharding.exception.metadata.DuplicateShardingActualDataNodeException;
import org.apache.shardingsphere.sharding.exception.metadata.ShardingTableRuleNotFoundException;
import org.apache.shardingsphere.sharding.exception.strategy.InvalidShardingStrategyConfigurationException;
import org.apache.shardingsphere.sharding.rule.BindingTableCheckedConfiguration;
import org.apache.shardingsphere.sharding.rule.ShardingTable;
import org.apache.shardingsphere.sharding.spi.ShardingAlgorithm;
import org.apache.shardingsphere.sharding.spi.ShardingAuditAlgorithm;

public final class ShardingTableRuleStatementChecker {
    private static final String DELIMITER = ".";

    public static void checkCreation(ShardingSphereDatabase database, Collection<AbstractTableRuleSegment> rules, boolean ifNotExists, ShardingRuleConfiguration currentRuleConfig) {
        ShardingTableRuleStatementChecker.check(database, rules, ifNotExists, currentRuleConfig, true);
    }

    public static void checkAlteration(ShardingSphereDatabase database, Collection<AbstractTableRuleSegment> rules, ShardingRuleConfiguration currentRuleConfig) {
        ShardingTableRuleStatementChecker.check(database, rules, false, currentRuleConfig, false);
    }

    public static boolean isValidBindingTableGroups(Collection<ShardingTableReferenceRuleConfiguration> bindingTableGroups, ShardingRuleConfiguration currentRuleConfig) {
        ShardingRuleConfiguration toBeCheckedRuleConfig = ShardingTableRuleStatementChecker.createToBeCheckedShardingRuleConfiguration(currentRuleConfig);
        toBeCheckedRuleConfig.setBindingTableGroups(bindingTableGroups);
        Collection<String> dataSourceNames = ShardingTableRuleStatementChecker.getRequiredDataSources(toBeCheckedRuleConfig);
        dataSourceNames.addAll(ShardingTableRuleStatementChecker.getRequiredDataSources(currentRuleConfig));
        return ShardingTableRuleStatementChecker.check(toBeCheckedRuleConfig, dataSourceNames);
    }

    private static ShardingRuleConfiguration createToBeCheckedShardingRuleConfiguration(ShardingRuleConfiguration currentRuleConfig) {
        ShardingRuleConfiguration result = new ShardingRuleConfiguration();
        result.setTables(new LinkedList(currentRuleConfig.getTables()));
        result.setAutoTables(new LinkedList(currentRuleConfig.getAutoTables()));
        result.setBindingTableGroups(new LinkedList(currentRuleConfig.getBindingTableGroups()));
        result.setDefaultTableShardingStrategy(currentRuleConfig.getDefaultTableShardingStrategy());
        result.setDefaultDatabaseShardingStrategy(currentRuleConfig.getDefaultDatabaseShardingStrategy());
        result.setDefaultKeyGenerateStrategy(currentRuleConfig.getDefaultKeyGenerateStrategy());
        result.setDefaultShardingColumn(currentRuleConfig.getDefaultShardingColumn());
        result.setShardingAlgorithms(new LinkedHashMap(currentRuleConfig.getShardingAlgorithms()));
        result.setKeyGenerators(new LinkedHashMap(currentRuleConfig.getKeyGenerators()));
        result.setAuditors(new LinkedHashMap(currentRuleConfig.getAuditors()));
        return result;
    }

    private static void check(ShardingSphereDatabase database, Collection<AbstractTableRuleSegment> rules, boolean ifNotExists, ShardingRuleConfiguration currentRuleConfig, boolean isCreated) {
        String databaseName = database.getName();
        ShardingTableRuleStatementChecker.checkTables(databaseName, rules, currentRuleConfig, isCreated, ifNotExists);
        ShardingTableRuleStatementChecker.checkDataSources(databaseName, rules, database);
        ShardingTableRuleStatementChecker.checkKeyGenerators(rules);
        ShardingTableRuleStatementChecker.checkAuditors(rules);
        ShardingTableRuleStatementChecker.checkAutoTableRule(rules.stream().filter(AutoTableRuleSegment.class::isInstance).map(AutoTableRuleSegment.class::cast).collect(Collectors.toList()));
        ShardingTableRuleStatementChecker.checkTableRule(rules.stream().filter(TableRuleSegment.class::isInstance).map(TableRuleSegment.class::cast).collect(Collectors.toList()));
        if (!isCreated) {
            ShardingTableRuleStatementChecker.checkBindingTableRules(rules, currentRuleConfig);
        }
    }

    private static boolean check(ShardingRuleConfiguration checkedConfig, Collection<String> dataSourceNames) {
        Collection<String> allDataSourceNames = ShardingTableRuleStatementChecker.getDataSourceNames(checkedConfig.getTables(), checkedConfig.getAutoTables(), dataSourceNames);
        HashMap<String, ShardingAlgorithm> shardingAlgorithms = new HashMap<String, ShardingAlgorithm>(checkedConfig.getShardingAlgorithms().size(), 1.0f);
        HashMap<String, ShardingTable> shardingTables = new HashMap<String, ShardingTable>();
        checkedConfig.getShardingAlgorithms().forEach((key, value) -> shardingAlgorithms.put((String)key, (ShardingAlgorithm)TypedSPILoader.getService(ShardingAlgorithm.class, (Object)value.getType(), (Properties)value.getProps())));
        shardingTables.putAll(ShardingTableRuleStatementChecker.createShardingTables(checkedConfig.getTables(), checkedConfig.getDefaultKeyGenerateStrategy(), allDataSourceNames));
        shardingTables.putAll(ShardingTableRuleStatementChecker.createShardingAutoTables(checkedConfig.getAutoTables(), shardingAlgorithms, checkedConfig.getDefaultKeyGenerateStrategy(), allDataSourceNames));
        NoneShardingStrategyConfiguration defaultDatabaseShardingStrategyConfig = null == checkedConfig.getDefaultDatabaseShardingStrategy() ? new NoneShardingStrategyConfiguration() : checkedConfig.getDefaultDatabaseShardingStrategy();
        NoneShardingStrategyConfiguration defaultTableShardingStrategyConfig = null == checkedConfig.getDefaultTableShardingStrategy() ? new NoneShardingStrategyConfiguration() : checkedConfig.getDefaultTableShardingStrategy();
        return ShardingTableRuleStatementChecker.isValidBindingTableConfiguration(shardingTables, new BindingTableCheckedConfiguration(allDataSourceNames, shardingAlgorithms, checkedConfig.getBindingTableGroups(), (ShardingStrategyConfiguration)defaultDatabaseShardingStrategyConfig, (ShardingStrategyConfiguration)defaultTableShardingStrategyConfig, checkedConfig.getDefaultShardingColumn()));
    }

    private static Collection<String> getDataSourceNames(Collection<ShardingTableRuleConfiguration> tableRuleConfigs, Collection<ShardingAutoTableRuleConfiguration> autoTableRuleConfigs, Collection<String> dataSourceNames) {
        if (tableRuleConfigs.isEmpty() && autoTableRuleConfigs.isEmpty()) {
            return dataSourceNames;
        }
        if (tableRuleConfigs.stream().map(ShardingTableRuleConfiguration::getActualDataNodes).anyMatch(each -> null == each || each.isEmpty())) {
            return dataSourceNames;
        }
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        tableRuleConfigs.forEach(each -> result.addAll(ShardingTableRuleStatementChecker.getDataSourceNames(each)));
        autoTableRuleConfigs.forEach(each -> result.addAll(InlineExpressionParserFactory.newInstance((String)each.getActualDataSources()).splitAndEvaluate()));
        return result;
    }

    private static Collection<String> getDataSourceNames(ShardingTableRuleConfiguration shardingTableRuleConfig) {
        return InlineExpressionParserFactory.newInstance((String)shardingTableRuleConfig.getActualDataNodes()).splitAndEvaluate().stream().map(each -> new DataNode(each).getDataSourceName()).collect(Collectors.toList());
    }

    private static Collection<String> getDataSourceNames(Collection<String> actualDataNodes) {
        LinkedHashSet<String> result = new LinkedHashSet<String>(actualDataNodes.size(), 1.0f);
        for (String each : actualDataNodes) {
            result.add(ShardingTableRuleStatementChecker.isValidDataNode(each) ? new DataNode(each).getDataSourceName() : each);
        }
        return result;
    }

    private static boolean isValidDataNode(String dataNodeStr) {
        return dataNodeStr.contains(DELIMITER) && 2 == Splitter.on((String)DELIMITER).omitEmptyStrings().splitToList((CharSequence)dataNodeStr).size();
    }

    private static Map<String, ShardingTable> createShardingTables(Collection<ShardingTableRuleConfiguration> tableRuleConfigs, KeyGenerateStrategyConfiguration defaultKeyGenerateStrategyConfig, Collection<String> dataSourceNames) {
        return tableRuleConfigs.stream().map(each -> new ShardingTable(each, dataSourceNames, ShardingTableRuleStatementChecker.getDefaultGenerateKeyColumn(defaultKeyGenerateStrategyConfig))).collect(Collectors.toMap(each -> each.getLogicTable().toLowerCase(), Function.identity(), (oldValue, currentValue) -> oldValue, LinkedHashMap::new));
    }

    private static String getDefaultGenerateKeyColumn(KeyGenerateStrategyConfiguration defaultKeyGenerateStrategyConfig) {
        return Optional.ofNullable(defaultKeyGenerateStrategyConfig).map(KeyGenerateStrategyConfiguration::getColumn).orElse(null);
    }

    private static Map<String, ShardingTable> createShardingAutoTables(Collection<ShardingAutoTableRuleConfiguration> autoTableRuleConfigs, Map<String, ShardingAlgorithm> shardingAlgorithms, KeyGenerateStrategyConfiguration defaultKeyGenerateStrategyConfig, Collection<String> dataSourceNames) {
        return autoTableRuleConfigs.stream().map(each -> ShardingTableRuleStatementChecker.createShardingAutoTable(defaultKeyGenerateStrategyConfig, each, shardingAlgorithms, dataSourceNames)).collect(Collectors.toMap(each -> each.getLogicTable().toLowerCase(), Function.identity(), (oldValue, currentValue) -> oldValue, LinkedHashMap::new));
    }

    private static ShardingTable createShardingAutoTable(KeyGenerateStrategyConfiguration defaultKeyGenerateStrategyConfig, ShardingAutoTableRuleConfiguration autoTableRuleConfig, Map<String, ShardingAlgorithm> shardingAlgorithms, Collection<String> dataSourceNames) {
        ShardingAlgorithm shardingAlgorithm = shardingAlgorithms.get(autoTableRuleConfig.getShardingStrategy().getShardingAlgorithmName());
        ShardingSpherePreconditions.checkState((boolean)(shardingAlgorithm instanceof ShardingAutoTableAlgorithm), () -> new ShardingAlgorithmClassImplementationException(autoTableRuleConfig.getShardingStrategy().getShardingAlgorithmName(), ShardingAutoTableAlgorithm.class));
        return new ShardingTable(autoTableRuleConfig, dataSourceNames, (ShardingAutoTableAlgorithm)shardingAlgorithm, ShardingTableRuleStatementChecker.getDefaultGenerateKeyColumn(defaultKeyGenerateStrategyConfig));
    }

    private static boolean isValidBindingTableConfiguration(Map<String, ShardingTable> shardingTables, BindingTableCheckedConfiguration checkedConfig) {
        for (ShardingTableReferenceRuleConfiguration each : checkedConfig.getBindingTableGroups()) {
            List bindingTables = Splitter.on((String)",").trimResults().splitToList((CharSequence)each.getReference().toLowerCase());
            if (bindingTables.size() <= 1) {
                return false;
            }
            Iterator iterator = bindingTables.iterator();
            ShardingTable sampleShardingTable = ShardingTableRuleStatementChecker.getShardingTable((String)iterator.next(), shardingTables);
            while (iterator.hasNext()) {
                ShardingTable shardingTable = ShardingTableRuleStatementChecker.getShardingTable((String)iterator.next(), shardingTables);
                if (!ShardingTableRuleStatementChecker.isValidActualDataSourceName(sampleShardingTable, shardingTable) || !ShardingTableRuleStatementChecker.isValidActualTableName(sampleShardingTable, shardingTable)) {
                    return false;
                }
                if (!ShardingTableRuleStatementChecker.isInvalidShardingAlgorithm(sampleShardingTable, shardingTable, true, checkedConfig) && !ShardingTableRuleStatementChecker.isInvalidShardingAlgorithm(sampleShardingTable, shardingTable, false, checkedConfig)) continue;
                return false;
            }
        }
        return true;
    }

    private static ShardingTable getShardingTable(String logicTableName, Map<String, ShardingTable> shardingTables) {
        ShardingTable result = shardingTables.get(logicTableName);
        if (null != result) {
            return result;
        }
        throw new ShardingTableRuleNotFoundException(Collections.singleton(logicTableName));
    }

    private static boolean isValidActualDataSourceName(ShardingTable sampleShardingTable, ShardingTable shardingTable) {
        return sampleShardingTable.getActualDataSourceNames().equals(shardingTable.getActualDataSourceNames());
    }

    private static boolean isValidActualTableName(ShardingTable sampleShardingTable, ShardingTable shardingTable) {
        for (String each : sampleShardingTable.getActualDataSourceNames()) {
            Collection actualTableNames;
            Collection sampleActualTableNames = sampleShardingTable.getActualTableNames(each).stream().map(actualTableName -> actualTableName.replace(sampleShardingTable.getTableDataNode().getPrefix(), "")).collect(Collectors.toSet());
            if (sampleActualTableNames.equals(actualTableNames = (Collection)shardingTable.getActualTableNames(each).stream().map(optional -> optional.replace(shardingTable.getTableDataNode().getPrefix(), "")).collect(Collectors.toSet()))) continue;
            return false;
        }
        return true;
    }

    private static boolean isInvalidShardingAlgorithm(ShardingTable sampleShardingTable, ShardingTable shardingTable, boolean databaseAlgorithm, BindingTableCheckedConfiguration checkedConfig) {
        return !ShardingTableRuleStatementChecker.getAlgorithmExpression(sampleShardingTable, databaseAlgorithm, checkedConfig).equals(ShardingTableRuleStatementChecker.getAlgorithmExpression(shardingTable, databaseAlgorithm, checkedConfig));
    }

    private static Optional<String> getAlgorithmExpression(ShardingTable shardingTable, boolean databaseAlgorithm, BindingTableCheckedConfiguration checkedConfig) {
        ShardingStrategyConfiguration shardingStrategyConfig = databaseAlgorithm ? ShardingTableRuleStatementChecker.getDatabaseShardingStrategyConfiguration(shardingTable, checkedConfig) : ShardingTableRuleStatementChecker.getTableShardingStrategyConfiguration(shardingTable, checkedConfig);
        ShardingAlgorithm shardingAlgorithm = (ShardingAlgorithm)checkedConfig.getShardingAlgorithms().get(shardingStrategyConfig.getShardingAlgorithmName());
        String dataNodePrefix = databaseAlgorithm ? shardingTable.getDataSourceDataNode().getPrefix() : shardingTable.getTableDataNode().getPrefix();
        String shardingColumn = ShardingTableRuleStatementChecker.getShardingColumn(shardingStrategyConfig, checkedConfig.getDefaultShardingColumn());
        return null == shardingAlgorithm ? Optional.empty() : shardingAlgorithm.getAlgorithmStructure(dataNodePrefix, shardingColumn);
    }

    private static ShardingStrategyConfiguration getDatabaseShardingStrategyConfiguration(ShardingTable shardingTable, BindingTableCheckedConfiguration checkedConfig) {
        return null == shardingTable.getDatabaseShardingStrategyConfig() ? checkedConfig.getDefaultDatabaseShardingStrategyConfig() : shardingTable.getDatabaseShardingStrategyConfig();
    }

    private static ShardingStrategyConfiguration getTableShardingStrategyConfiguration(ShardingTable shardingTable, BindingTableCheckedConfiguration checkedConfig) {
        return null == shardingTable.getTableShardingStrategyConfig() ? checkedConfig.getDefaultTableShardingStrategyConfig() : shardingTable.getTableShardingStrategyConfig();
    }

    private static String getShardingColumn(ShardingStrategyConfiguration shardingStrategyConfig, String defaultShardingColumn) {
        String shardingColumn = defaultShardingColumn;
        if (shardingStrategyConfig instanceof ComplexShardingStrategyConfiguration) {
            shardingColumn = ((ComplexShardingStrategyConfiguration)shardingStrategyConfig).getShardingColumns();
        }
        if (shardingStrategyConfig instanceof StandardShardingStrategyConfiguration) {
            shardingColumn = ((StandardShardingStrategyConfiguration)shardingStrategyConfig).getShardingColumn();
        }
        return null == shardingColumn ? "" : shardingColumn;
    }

    private static void checkDataSources(String databaseName, Collection<AbstractTableRuleSegment> rules, ShardingSphereDatabase database) {
        Collection<String> requiredDataSource = ShardingTableRuleStatementChecker.getRequiredDataSources(rules);
        Collection notExistedDataSources = database.getResourceMetaData().getNotExistedDataSources(requiredDataSource);
        Collection<String> logicDataSources = ShardingTableRuleStatementChecker.getLogicDataSources(database);
        notExistedDataSources.removeIf(logicDataSources::contains);
        ShardingSpherePreconditions.checkMustEmpty((Collection)notExistedDataSources, () -> new MissingRequiredStorageUnitsException(databaseName, notExistedDataSources));
    }

    private static Collection<String> getRequiredDataSources(ShardingRuleConfiguration config) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        result.addAll(config.getAutoTables().stream().map(ShardingAutoTableRuleConfiguration::getActualDataSources).map(each -> Splitter.on((String)",").trimResults().splitToList((CharSequence)each)).flatMap(Collection::stream).collect(Collectors.toSet()));
        result.addAll(config.getTables().stream().map(each -> InlineExpressionParserFactory.newInstance((String)each.getActualDataNodes()).splitAndEvaluate()).flatMap(Collection::stream).distinct().map(each -> new DataNode(each).getDataSourceName()).collect(Collectors.toSet()));
        return result;
    }

    private static <T extends AbstractTableRuleSegment> Collection<String> getRequiredDataSources(Collection<T> rules) {
        return rules.stream().map(AbstractTableRuleSegment::getDataSourceNodes).flatMap(Collection::stream).map(ShardingTableRuleStatementChecker::parseDateSource).map(ShardingTableRuleStatementChecker::getDataSourceNames).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private static Collection<String> parseDateSource(String dateSource) {
        return InlineExpressionParserFactory.newInstance((String)dateSource).splitAndEvaluate();
    }

    private static Collection<String> getLogicDataSources(ShardingSphereDatabase database) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (DataSourceMapperRuleAttribute each : database.getRuleMetaData().getAttributes(DataSourceMapperRuleAttribute.class)) {
            result.addAll(each.getDataSourceMapper().keySet());
        }
        return result;
    }

    private static void checkTables(String databaseName, Collection<AbstractTableRuleSegment> rules, ShardingRuleConfiguration currentRuleConfig, boolean isCreate, boolean ifNotExists) {
        List<String> currentShardingTables;
        Collection requiredTables = rules.stream().map(AbstractTableRuleSegment::getLogicTable).collect(Collectors.toList());
        Collection<String> duplicatedRuleNames = ShardingTableRuleStatementChecker.getDuplicatedRuleNames(requiredTables);
        ShardingSpherePreconditions.checkMustEmpty(duplicatedRuleNames, () -> new DuplicateRuleException("sharding", databaseName, duplicatedRuleNames));
        Collection<Object> collection = currentShardingTables = null == currentRuleConfig ? Collections.emptyList() : ShardingTableRuleStatementChecker.getCurrentShardingTables(currentRuleConfig);
        if (isCreate) {
            if (!ifNotExists) {
                duplicatedRuleNames.addAll(ShardingTableRuleStatementChecker.getDuplicatedRuleNames(requiredTables, currentShardingTables));
                ShardingSpherePreconditions.checkMustEmpty(duplicatedRuleNames, () -> new DuplicateRuleException("sharding", databaseName, duplicatedRuleNames));
            }
        } else {
            Set<String> notExistedRules = ShardingTableRuleStatementChecker.getNotExistedRules(requiredTables, currentShardingTables);
            ShardingSpherePreconditions.checkMustEmpty(notExistedRules, () -> new MissingRequiredRuleException("sharding", databaseName, notExistedRules));
        }
    }

    private static Collection<String> getDuplicatedRuleNames(Collection<String> collection) {
        Collection duplicatedNames = (Collection)collection.stream().collect(Collectors.groupingBy(String::toLowerCase, Collectors.counting())).entrySet().stream().filter(each -> (Long)each.getValue() > 1L).map(Map.Entry::getKey).collect(Collectors.toCollection(CaseInsensitiveSet::new));
        return collection.stream().filter(duplicatedNames::contains).collect(Collectors.toSet());
    }

    private static Collection<String> getDuplicatedRuleNames(Collection<String> requiredRuleNames, Collection<String> currentRuleNames) {
        return requiredRuleNames.stream().filter(currentRuleNames::contains).collect(Collectors.toSet());
    }

    private static Set<String> getNotExistedRules(Collection<String> requiredRuleNames, Collection<String> currentRuleNames) {
        return requiredRuleNames.stream().filter(each -> !currentRuleNames.contains(each)).collect(Collectors.toSet());
    }

    private static Collection<String> getCurrentShardingTables(ShardingRuleConfiguration currentRuleConfig) {
        CaseInsensitiveSet result = new CaseInsensitiveSet();
        result.addAll(currentRuleConfig.getTables().stream().map(ShardingTableRuleConfiguration::getLogicTable).collect(Collectors.toSet()));
        result.addAll(currentRuleConfig.getAutoTables().stream().map(ShardingAutoTableRuleConfiguration::getLogicTable).collect(Collectors.toSet()));
        return result;
    }

    private static void checkKeyGenerators(Collection<AbstractTableRuleSegment> rules) {
        rules.stream().map(AbstractTableRuleSegment::getKeyGenerateStrategySegment).filter(Objects::nonNull).map(KeyGenerateStrategySegment::getKeyGenerateAlgorithmSegment).forEach(each -> TypedSPILoader.checkService(KeyGenerateAlgorithm.class, (Object)each.getName(), (Properties)each.getProps()));
    }

    private static void checkAuditors(Collection<AbstractTableRuleSegment> rules) {
        Collection auditStrategySegments = rules.stream().map(AbstractTableRuleSegment::getAuditStrategySegment).filter(Objects::nonNull).collect(Collectors.toList());
        LinkedHashSet requiredAuditors = new LinkedHashSet();
        for (AuditStrategySegment each2 : auditStrategySegments) {
            requiredAuditors.addAll(each2.getAuditorSegments().stream().map(ShardingAuditorSegment::getAlgorithmSegment).collect(Collectors.toList()));
        }
        requiredAuditors.forEach(each -> TypedSPILoader.checkService(ShardingAuditAlgorithm.class, (Object)each.getName(), (Properties)each.getProps()));
    }

    private static void checkAutoTableRule(Collection<AutoTableRuleSegment> autoTableRules) {
        ShardingTableRuleStatementChecker.checkAutoTableShardingAlgorithms(autoTableRules);
    }

    private static void checkAutoTableShardingAlgorithms(Collection<AutoTableRuleSegment> autoTableRules) {
        autoTableRules.forEach(each -> {
            ShardingAlgorithm shardingAlgorithm = (ShardingAlgorithm)TypedSPILoader.getService(ShardingAlgorithm.class, (Object)each.getShardingAlgorithmSegment().getName(), (Properties)each.getShardingAlgorithmSegment().getProps());
            ShardingSpherePreconditions.checkState((boolean)(shardingAlgorithm instanceof ShardingAutoTableAlgorithm), () -> new AlgorithmInitializationException((ShardingSphereAlgorithm)shardingAlgorithm, "Auto sharding algorithm is required for table '%s'", new Object[]{each.getLogicTable()}));
        });
    }

    private static void checkTableRule(Collection<TableRuleSegment> tableRules) {
        ShardingTableRuleStatementChecker.checkStrategy(tableRules);
    }

    private static void checkStrategy(Collection<TableRuleSegment> rules) {
        for (TableRuleSegment each : rules) {
            Optional<ShardingStrategySegment> tableStrategySegment;
            Optional<ShardingStrategySegment> databaseStrategySegment = Optional.ofNullable(each.getDatabaseStrategySegment());
            if (databaseStrategySegment.isPresent()) {
                if ("none".equalsIgnoreCase(databaseStrategySegment.get().getType())) {
                    Collection<String> requiredDataSources = ShardingTableRuleStatementChecker.getRequiredDataSources(rules);
                    ShardingSpherePreconditions.checkState((1 == requiredDataSources.size() ? 1 : 0) != 0, () -> new InvalidShardingStrategyConfigurationException("database", ((ShardingStrategySegment)databaseStrategySegment.get()).getType()));
                } else {
                    AlgorithmSegment databaseShardingAlgorithm = databaseStrategySegment.get().getShardingAlgorithm();
                    ShardingTableRuleStatementChecker.checkDatabaseShardingAlgorithm(each, databaseShardingAlgorithm);
                }
            }
            if (!(tableStrategySegment = Optional.ofNullable(each.getTableStrategySegment())).isPresent()) continue;
            if ("none".equalsIgnoreCase(tableStrategySegment.get().getType())) {
                Collection<String> requiredTables = ShardingTableRuleStatementChecker.getRequiredTables(rules);
                ShardingSpherePreconditions.checkState((1 == requiredTables.size() ? 1 : 0) != 0, () -> new InvalidShardingStrategyConfigurationException("table", ((ShardingStrategySegment)tableStrategySegment.get()).getType()));
                continue;
            }
            AlgorithmSegment tableShardingAlgorithm = tableStrategySegment.get().getShardingAlgorithm();
            ShardingTableRuleStatementChecker.checkTableShardingAlgorithm(each, tableShardingAlgorithm);
        }
    }

    private static void checkDatabaseShardingAlgorithm(TableRuleSegment each, AlgorithmSegment databaseShardingAlgorithm) {
        if (null != databaseShardingAlgorithm) {
            ShardingAlgorithm shardingAlgorithm = (ShardingAlgorithm)TypedSPILoader.getService(ShardingAlgorithm.class, (Object)databaseShardingAlgorithm.getName(), (Properties)databaseShardingAlgorithm.getProps());
            ShardingSpherePreconditions.checkState((!(shardingAlgorithm instanceof ShardingAutoTableAlgorithm) ? 1 : 0) != 0, () -> new AlgorithmInitializationException((ShardingSphereAlgorithm)shardingAlgorithm, "Auto sharding algorithm can not be used to create a table in table '%s'", new Object[]{each.getLogicTable()}));
        }
        ShardingSpherePreconditions.checkState((boolean)ShardingTableRuleStatementChecker.isValidStrategy(each.getDatabaseStrategySegment()), () -> new InvalidAlgorithmConfigurationException("sharding", null == databaseShardingAlgorithm ? null : databaseShardingAlgorithm.getName()));
    }

    private static void checkTableShardingAlgorithm(TableRuleSegment each, AlgorithmSegment tableShardingAlgorithm) {
        if (null != tableShardingAlgorithm) {
            ShardingAlgorithm shardingAlgorithm = (ShardingAlgorithm)TypedSPILoader.getService(ShardingAlgorithm.class, (Object)tableShardingAlgorithm.getName(), (Properties)tableShardingAlgorithm.getProps());
            ShardingSpherePreconditions.checkState((!(shardingAlgorithm instanceof ShardingAutoTableAlgorithm) ? 1 : 0) != 0, () -> new AlgorithmInitializationException((ShardingSphereAlgorithm)shardingAlgorithm, "Auto sharding algorithm can not be used to create a table in table '%s'", new Object[]{each.getLogicTable()}));
        }
        ShardingSpherePreconditions.checkState((boolean)ShardingTableRuleStatementChecker.isValidStrategy(each.getTableStrategySegment()), () -> new InvalidAlgorithmConfigurationException("sharding", null == tableShardingAlgorithm ? null : tableShardingAlgorithm.getName()));
    }

    private static boolean isValidStrategy(ShardingStrategySegment shardingStrategySegment) {
        return ShardingStrategyType.getValueOf(shardingStrategySegment.getType()).isValid(shardingStrategySegment.getShardingColumn()) && null != shardingStrategySegment.getShardingAlgorithm();
    }

    private static Collection<String> getRequiredTables(Collection<TableRuleSegment> rules) {
        return rules.stream().map(AbstractTableRuleSegment::getDataSourceNodes).flatMap(Collection::stream).map(ShardingTableRuleStatementChecker::parseDateSource).map(ShardingTableRuleStatementChecker::getTableNames).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private static Collection<String> getTableNames(Collection<String> actualDataNodes) {
        HashSet<String> result = new HashSet<String>(actualDataNodes.size(), 1.0f);
        for (String each : actualDataNodes) {
            result.add(ShardingTableRuleStatementChecker.isValidDataNode(each) ? new DataNode(each).getTableName() : each);
        }
        return result;
    }

    private static void checkBindingTableRules(Collection<AbstractTableRuleSegment> rules, ShardingRuleConfiguration currentRuleConfig) {
        if (null == currentRuleConfig || currentRuleConfig.getBindingTableGroups().isEmpty()) {
            return;
        }
        Collection<String> bindingTables = ShardingTableRuleStatementChecker.getCurrentBindingTables(currentRuleConfig);
        if (bindingTables.size() <= 1) {
            return;
        }
        ShardingRuleConfiguration toBeAlteredRuleConfig = ShardingTableRuleStatementConverter.convert(rules);
        Collection<String> toBeAlteredLogicTableNames = ShardingTableRuleStatementChecker.getAlteredLogicalTableNames(toBeAlteredRuleConfig);
        Collection toBeAlteredBindingTableNames = toBeAlteredLogicTableNames.stream().filter(bindingTables::contains).collect(Collectors.toSet());
        if (toBeAlteredBindingTableNames.isEmpty()) {
            return;
        }
        ShardingRuleConfiguration toBeCheckedRuleConfig = ShardingTableRuleStatementChecker.createToBeCheckedShardingRuleConfiguration(currentRuleConfig);
        ShardingTableRuleStatementChecker.removeRuleConfiguration(toBeCheckedRuleConfig, toBeAlteredRuleConfig);
        ShardingTableRuleStatementChecker.addRuleConfiguration(toBeCheckedRuleConfig, toBeAlteredRuleConfig);
        Collection<String> dataSourceNames = ShardingTableRuleStatementChecker.getRequiredDataSources(toBeCheckedRuleConfig);
        dataSourceNames.addAll(ShardingTableRuleStatementChecker.getRequiredDataSources(toBeAlteredRuleConfig));
        ShardingSpherePreconditions.checkState((boolean)ShardingTableRuleStatementChecker.check(toBeCheckedRuleConfig, dataSourceNames), () -> new InvalidRuleConfigurationException("sharding table", toBeAlteredLogicTableNames, Collections.singleton("invalid binding table configuration.")));
    }

    private static Collection<String> getCurrentBindingTables(ShardingRuleConfiguration currentRuleConfig) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        currentRuleConfig.getBindingTableGroups().forEach(each -> result.addAll(Splitter.on((String)",").trimResults().splitToList((CharSequence)each.getReference())));
        return result;
    }

    private static void removeRuleConfiguration(ShardingRuleConfiguration currentRuleConfig, ShardingRuleConfiguration toBeAlteredRuleConfig) {
        Collection<String> toBeAlteredLogicTableNames = ShardingTableRuleStatementChecker.getAlteredLogicalTableNames(toBeAlteredRuleConfig);
        toBeAlteredLogicTableNames.forEach(each -> {
            currentRuleConfig.getTables().removeIf(table -> table.getLogicTable().equalsIgnoreCase((String)each));
            currentRuleConfig.getAutoTables().removeIf(table -> table.getLogicTable().equalsIgnoreCase((String)each));
        });
    }

    private static void addRuleConfiguration(ShardingRuleConfiguration currentRuleConfig, ShardingRuleConfiguration toBeAlteredRuleConfig) {
        currentRuleConfig.getTables().addAll(toBeAlteredRuleConfig.getTables());
        currentRuleConfig.getAutoTables().addAll(toBeAlteredRuleConfig.getAutoTables());
        currentRuleConfig.getShardingAlgorithms().putAll(toBeAlteredRuleConfig.getShardingAlgorithms());
        currentRuleConfig.getKeyGenerators().putAll(toBeAlteredRuleConfig.getKeyGenerators());
    }

    private static Collection<String> getAlteredLogicalTableNames(ShardingRuleConfiguration toBeAlteredRuleConfig) {
        Collection result = toBeAlteredRuleConfig.getTables().stream().map(ShardingTableRuleConfiguration::getLogicTable).collect(Collectors.toList());
        result.addAll(toBeAlteredRuleConfig.getAutoTables().stream().map(ShardingAutoTableRuleConfiguration::getLogicTable).collect(Collectors.toList()));
        return result;
    }

    public static void checkToBeAddedDataNodes(Map<String, Collection<DataNode>> toBeAddedDataNodes) {
        HashSet uniqueActualDataNodes = new HashSet(toBeAddedDataNodes.size(), 1.0f);
        toBeAddedDataNodes.forEach((key, value) -> {
            DataNode sampleActualDataNode = (DataNode)value.iterator().next();
            ShardingSpherePreconditions.checkNotContains((Collection)uniqueActualDataNodes, (Object)sampleActualDataNode, () -> new DuplicateShardingActualDataNodeException(key, sampleActualDataNode.getDataSourceName(), sampleActualDataNode.getTableName()));
            uniqueActualDataNodes.add(sampleActualDataNode);
        });
    }

    @Generated
    private ShardingTableRuleStatementChecker() {
    }
}

