/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mask.rule.changed;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import org.apache.shardingsphere.infra.algorithm.core.config.AlgorithmConfiguration;
import org.apache.shardingsphere.infra.algorithm.core.yaml.YamlAlgorithmConfiguration;
import org.apache.shardingsphere.infra.algorithm.core.yaml.YamlAlgorithmConfigurationSwapper;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.mask.config.MaskRuleConfiguration;
import org.apache.shardingsphere.mask.rule.MaskRule;
import org.apache.shardingsphere.mode.event.dispatch.rule.alter.AlterNamedRuleItemEvent;
import org.apache.shardingsphere.mode.event.dispatch.rule.alter.AlterRuleItemEvent;
import org.apache.shardingsphere.mode.event.dispatch.rule.drop.DropNamedRuleItemEvent;
import org.apache.shardingsphere.mode.event.dispatch.rule.drop.DropRuleItemEvent;
import org.apache.shardingsphere.mode.spi.RuleItemConfigurationChangedProcessor;

public final class MaskAlgorithmChangedProcessor
implements RuleItemConfigurationChangedProcessor<MaskRuleConfiguration, AlgorithmConfiguration> {
    public AlgorithmConfiguration swapRuleItemConfiguration(AlterRuleItemEvent event, String yamlContent) {
        return new YamlAlgorithmConfigurationSwapper().swapToObject((YamlAlgorithmConfiguration)YamlEngine.unmarshal((String)yamlContent, YamlAlgorithmConfiguration.class));
    }

    public MaskRuleConfiguration findRuleConfiguration(ShardingSphereDatabase database) {
        return database.getRuleMetaData().findSingleRule(MaskRule.class).map(optional -> this.getConfiguration(optional.getConfiguration())).orElseGet(() -> new MaskRuleConfiguration(new LinkedList(), new LinkedHashMap()));
    }

    private MaskRuleConfiguration getConfiguration(MaskRuleConfiguration ruleConfig) {
        return null == ruleConfig.getMaskAlgorithms() ? new MaskRuleConfiguration(ruleConfig.getTables(), new LinkedHashMap()) : ruleConfig;
    }

    public void changeRuleItemConfiguration(AlterRuleItemEvent event, MaskRuleConfiguration currentRuleConfig, AlgorithmConfiguration toBeChangedItemConfig) {
        currentRuleConfig.getMaskAlgorithms().put(((AlterNamedRuleItemEvent)event).getItemName(), toBeChangedItemConfig);
    }

    public void dropRuleItemConfiguration(DropRuleItemEvent event, MaskRuleConfiguration currentRuleConfig) {
        currentRuleConfig.getMaskAlgorithms().remove(((DropNamedRuleItemEvent)event).getItemName());
    }

    public String getType() {
        return "mask.mask_algorithms";
    }
}

